/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.logging;

import leap.lang.Strings;
import leap.lang.logging.Log;
import leap.lang.logging.LogLevel;
import leap.lang.logging.SlfLog;
import leap.lang.logging.StdLog;
import org.slf4j.LoggerFactory;

public final class LogFactory {
    private static final boolean slf4j = LogFactory.slf4j();
    private static final StdLog std;

    public static Log get(String name) {
        return slf4j ? LogFactory.getSlf4jLogger(name) : std;
    }

    public static Log get(Class<?> clazz) {
        return slf4j ? LogFactory.getSlf4jLogger(clazz) : std;
    }

    private static Log getSlf4jLogger(String name) {
        return new SlfLog(LoggerFactory.getLogger((String)name));
    }

    private static Log getSlf4jLogger(Class<?> clazz) {
        return new SlfLog(LoggerFactory.getLogger(clazz));
    }

    private static boolean forName(String className) {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = LogFactory.class.getClassLoader();
        }
        try {
            return null != cl.loadClass(className);
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static boolean slf4j() {
        boolean slf4j = LogFactory.forName("org.slf4j.impl.StaticLoggerBinder");
        if (slf4j) {
            SlfLog.init();
        }
        return slf4j;
    }

    static {
        String lvName = System.getProperty("app.stdlog.level");
        if (Strings.isEmpty(lvName)) {
            lvName = "warn";
        }
        LogLevel lv = LogLevel.byName(lvName);
        std = new StdLog(lv);
    }
}

