/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.logging;

import leap.lang.Valued;

public enum LogLevel implements Valued<Integer>
{
    Trace(-4),
    Debug(-3),
    Info(-2),
    Warn(-1),
    Error(0);

    private final int value;

    private LogLevel(int value) {
        this.value = value;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public boolean isTraceEnabled() {
        return this.value < LogLevel.Debug.value;
    }

    public boolean isDebugEnabled() {
        return this.value > LogLevel.Trace.value;
    }

    public boolean isInfoEnabled() {
        return this.value > LogLevel.Debug.value;
    }

    public boolean isWarnEnabled() {
        return this.value > LogLevel.Info.value;
    }

    public boolean isErrorEnabled() {
        return this.value > LogLevel.Warn.value;
    }

    public static LogLevel byName(String name) {
        if ("trace".equalsIgnoreCase(name)) {
            return Trace;
        }
        if ("debug".equalsIgnoreCase(name)) {
            return Debug;
        }
        if ("info".equalsIgnoreCase(name)) {
            return Info;
        }
        if ("warn".equalsIgnoreCase(name)) {
            return Warn;
        }
        if ("error".equalsIgnoreCase(name)) {
            return Error;
        }
        throw new IllegalArgumentException("invalid log level name '" + name + "'");
    }
}

