/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.logging;

import leap.lang.path.Paths;
import leap.lang.resource.Resource;

public class LogUtils {
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String USER_DIR_WITH_PREFIX = "file:" + Paths.normalize(System.getProperty("user.dir"));

    public static String getFilePath(String path) {
        if (null == path) {
            return null;
        }
        if (path.startsWith(USER_DIR)) {
            return "." + path.substring(USER_DIR.length());
        }
        return path;
    }

    public static String getUrl(Resource r) {
        if (null == r) {
            return null;
        }
        return LogUtils.getUrl(r.getURLString());
    }

    public static String getUrl(String url) {
        int start;
        int index;
        if (url.startsWith(USER_DIR_WITH_PREFIX)) {
            url = "." + url.substring(USER_DIR_WITH_PREFIX.length());
        } else if (url.startsWith("jar:") && (index = url.indexOf(".jar!/")) > 0 && (start = url.lastIndexOf(47, index)) > 0) {
            return url.substring(start + 1);
        }
        return url;
    }

    protected LogUtils() {
    }
}

