/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.logging;

import ch.qos.logback.classic.LoggerContext;
import leap.lang.Classes;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SlfLog
implements Log {
    private final Logger logger;

    public SlfLog(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.logger.trace(msg);
        }
    }

    @Override
    public void trace(Throwable throwable) {
        if (this.isTraceEnabled()) {
            if (null == throwable) {
                this.logNullThrowable();
            } else {
                this.logger.trace(throwable.getMessage(), throwable);
            }
        }
    }

    @Override
    public void trace(String msg, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.logger.trace(msg, throwable);
        }
    }

    @Override
    public void trace(String msg, Object ... args) {
        if (this.isTraceEnabled()) {
            this.logger.trace(msg, args);
        }
    }

    @Override
    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.logger.debug(msg);
        }
    }

    @Override
    public void debug(Throwable throwable) {
        if (this.isDebugEnabled()) {
            if (null == throwable) {
                this.logNullThrowable();
            } else {
                this.logger.debug(throwable.getMessage(), throwable);
            }
        }
    }

    @Override
    public void debug(String msg, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.logger.debug(msg, throwable);
        }
    }

    @Override
    public void debug(String msg, Object ... args) {
        if (this.isDebugEnabled()) {
            this.logger.debug(msg, args);
        }
    }

    @Override
    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.logger.info(msg);
        }
    }

    @Override
    public void info(Throwable throwable) {
        if (this.isInfoEnabled()) {
            if (null == throwable) {
                this.logNullThrowable();
            } else {
                this.logger.info(throwable.getMessage(), throwable);
            }
        }
    }

    @Override
    public void info(String msg, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.logger.info(msg, throwable);
        }
    }

    @Override
    public void info(String msg, Object ... args) {
        if (this.isInfoEnabled()) {
            this.logger.info(msg, args);
        }
    }

    @Override
    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.logger.warn(msg);
        }
    }

    @Override
    public void warn(Throwable throwable) {
        if (this.isWarnEnabled()) {
            if (null == throwable) {
                this.logNullThrowable();
            } else {
                this.logger.warn(throwable.getMessage(), throwable);
            }
        }
    }

    @Override
    public void warn(String msg, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.logger.warn(msg, throwable);
        }
    }

    @Override
    public void warn(String msg, Object ... args) {
        if (this.isWarnEnabled()) {
            this.logger.warn(msg, args);
        }
    }

    @Override
    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.logger.error(msg);
        }
    }

    @Override
    public void error(Throwable throwable) {
        if (this.isErrorEnabled()) {
            if (null == throwable) {
                this.logNullThrowable();
            } else {
                this.logger.error(throwable.getMessage(), throwable);
            }
        }
    }

    @Override
    public void error(String msg, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.logger.error(msg, throwable);
        }
    }

    @Override
    public void error(String msg, Object ... args) {
        if (this.isErrorEnabled()) {
            this.logger.error(msg, args);
        }
    }

    private void logNullThrowable() {
        if (this.isInfoEnabled()) {
            this.logger.info("null input in logging");
        }
    }

    static void init() {
        if (null != Classes.tryForName("ch.qos.logback.classic.LoggerContext")) {
            SlfLog.initLogback();
        }
    }

    private static void initLogback() {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        lc.getFrameworkPackages().add(Classes.getPackageName(LogFactory.class));
    }
}

