/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.logging;

public class StackTraceStringBuilder {
    private final String message;
    private final StackTraceElement[] stes;

    public StackTraceStringBuilder(StackTraceElement[] stes) {
        this(null, stes);
    }

    public StackTraceStringBuilder(String message, StackTraceElement[] stes) {
        if (null == stes) {
            throw new IllegalArgumentException("The stack trace elements must not be null");
        }
        this.message = message;
        this.stes = stes;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (null != this.message) {
            s.append(this.message).append('\n');
        }
        for (StackTraceElement ste : this.stes) {
            s.append("at ").append(ste.toString()).append('\n');
        }
        return s.toString();
    }
}

