/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.logging;

import leap.lang.Strings;
import leap.lang.logging.Log;
import leap.lang.logging.LogLevel;

final class StdLog
implements Log {
    private boolean trace = false;
    private boolean debug = false;
    private boolean info = false;
    private boolean warn = true;
    private boolean error = true;

    @Override
    public boolean isTraceEnabled() {
        return this.trace;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debug;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.info;
    }

    @Override
    public boolean isWarnEnabled() {
        return this.warn;
    }

    @Override
    public boolean isErrorEnabled() {
        return this.error;
    }

    public StdLog(LogLevel lv) {
        this.trace = lv.isTraceEnabled();
        this.debug = lv.isDebugEnabled();
        this.info = lv.isInfoEnabled();
        this.warn = lv.isWarnEnabled();
        this.error = lv.isErrorEnabled();
    }

    @Override
    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.out(msg);
        }
    }

    @Override
    public void trace(Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.out(throwable);
        }
    }

    @Override
    public void trace(String msg, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.out(msg, throwable);
        }
    }

    @Override
    public void trace(String msg, Object ... args) {
        if (this.isTraceEnabled()) {
            this.out(msg, args);
        }
    }

    @Override
    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.out(msg);
        }
    }

    @Override
    public void debug(Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.out(throwable);
        }
    }

    @Override
    public void debug(String msg, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.out(msg, throwable);
        }
    }

    @Override
    public void debug(String msg, Object ... args) {
        if (this.isDebugEnabled()) {
            this.out(msg, args);
        }
    }

    @Override
    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.out(msg);
        }
    }

    @Override
    public void info(Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.out(throwable);
        }
    }

    @Override
    public void info(String msg, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.out(msg, throwable);
        }
    }

    @Override
    public void info(String msg, Object ... args) {
        if (this.isInfoEnabled()) {
            this.out(msg, args);
        }
    }

    @Override
    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.err(msg);
        }
    }

    @Override
    public void warn(Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.err(throwable);
        }
    }

    @Override
    public void warn(String msg, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.err(msg, throwable);
        }
    }

    @Override
    public void warn(String msg, Object ... args) {
        if (this.isWarnEnabled()) {
            this.err(msg, args);
        }
    }

    @Override
    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.err(msg);
        }
    }

    @Override
    public void error(Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.err(throwable);
        }
    }

    @Override
    public void error(String msg, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.err(msg, throwable);
        }
    }

    @Override
    public void error(String msg, Object ... args) {
        if (this.isErrorEnabled()) {
            this.err(msg, args);
        }
    }

    private void out(String msg) {
        System.out.println(msg);
    }

    private void out(Throwable throwable) {
        if (null == throwable) {
            this.logNullThrowable();
        } else {
            System.out.println(throwable.getMessage());
            throwable.printStackTrace(System.out);
        }
    }

    private void out(String msg, Throwable throwable) {
        System.out.println(msg);
        if (null != throwable) {
            throwable.printStackTrace(System.out);
        }
    }

    private void out(String msg, Object ... args) {
        System.out.println(StdLog.format(msg, args));
        if (null != args && args.length > 0 && args[args.length - 1] instanceof Throwable) {
            ((Throwable)args[args.length - 1]).printStackTrace(System.out);
        }
    }

    private void err(String msg) {
        System.err.println(msg);
    }

    private void err(Throwable throwable) {
        if (null == throwable) {
            this.logNullThrowable();
        } else {
            System.err.println(throwable.getMessage());
            throwable.printStackTrace(System.err);
        }
    }

    private void err(String msg, Throwable throwable) {
        System.err.println(msg);
        if (null != throwable) {
            throwable.printStackTrace(System.err);
        }
    }

    private void err(String msg, Object ... args) {
        System.err.println(StdLog.format(msg, args));
        if (null != args && args.length > 0 && args[args.length - 1] instanceof Throwable) {
            ((Throwable)args[args.length - 1]).printStackTrace(System.err);
        }
    }

    private void logNullThrowable() {
        if (this.isInfoEnabled()) {
            System.out.println("null input in logging");
        }
    }

    private static String format(String template, Object ... args) {
        if (Strings.isEmpty(template)) {
            return "";
        }
        char[] templateChars = template.toCharArray();
        int templateLength = templateChars.length;
        int length = 0;
        int tokenCount = args.length;
        for (int i = 0; i < tokenCount; ++i) {
            Object sourceString = args[i];
            if (sourceString == null) continue;
            length += sourceString.toString().length();
        }
        StringBuilder buffer = new StringBuilder(length + templateLength);
        int lastStart = 0;
        int tokenIndex = 0;
        for (int i = 0; i < templateLength; ++i) {
            char ch = templateChars[i];
            if (ch != '{' || i + 1 >= templateLength || templateChars[i + 1] != '}' || tokenIndex < 0 || tokenIndex >= tokenCount) continue;
            buffer.append(templateChars, lastStart, i - lastStart);
            Object sourceString = args[tokenIndex];
            if (sourceString != null) {
                buffer.append(sourceString.toString());
            }
            lastStart = ++i + 1;
            ++tokenIndex;
        }
        buffer.append(templateChars, lastStart, templateLength - lastStart);
        return new String(buffer);
    }
}

