/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.meta;

import java.util.Collection;
import leap.lang.Args;
import leap.lang.Strings;
import leap.lang.meta.MComplexTypeRef;
import leap.lang.meta.MNamed;
import leap.lang.meta.MProperty;
import leap.lang.meta.MStructuralType;
import leap.lang.meta.MTypeKind;

public class MComplexType
extends MStructuralType
implements MNamed {
    protected final String name;
    protected final String title;
    protected final MComplexType baseType;
    protected final Class<?> javaType;
    protected final boolean _abstract;

    public MComplexType(String name, String title, String summary, String description, MComplexType baseType, Class<?> javaType, Collection<MProperty> properties, boolean isAbstract) {
        super(summary, description, properties);
        Args.notEmpty(name, "name");
        this.name = name;
        this.title = Strings.isEmpty(title) ? name : title;
        this.baseType = baseType;
        this.javaType = javaType;
        this._abstract = isAbstract;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public MTypeKind getTypeKind() {
        return MTypeKind.COMPLEX;
    }

    public MComplexType getBaseType() {
        return this.baseType;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public boolean isAbstract() {
        return this._abstract;
    }

    public MComplexTypeRef createTypeRef() {
        return new MComplexTypeRef(this.name);
    }
}

