/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.meta;

import java.lang.reflect.Type;
import leap.lang.Args;
import leap.lang.Out;
import leap.lang.Strings;
import leap.lang.convert.AbstractConverter;
import leap.lang.convert.ConvertContext;
import leap.lang.convert.Converts;
import leap.lang.jdbc.JdbcType;
import leap.lang.meta.MNamed;
import leap.lang.meta.MSimpleTypeKind;
import leap.lang.meta.MSimpleTypes;
import leap.lang.meta.MType;
import leap.lang.meta.MTypeKind;

public class MSimpleType
extends MType
implements MNamed {
    protected final String name;
    protected final String title;
    protected final MSimpleTypeKind simpleTypeKind;
    protected final JdbcType jdbcType;
    protected final Class<?> javaType;
    protected final Class<?>[] javaTypes;
    protected final Integer defaultLength;
    protected final Integer defaultPrecision;
    protected final Integer defaultScale;

    protected MSimpleType(String name, String title, String summary, String description, MSimpleTypeKind simpleTypeKind, JdbcType jdbcType, Class<?> javaType, Class<?>[] javaTypes, Integer defaultLength, Integer defaultPrecision, Integer defaultScale) {
        super(summary, description);
        Args.notEmpty(name, "name");
        Args.notNull(jdbcType, "jdbcType");
        Args.notNull(javaType, "javaType");
        Args.notEmpty(javaTypes, "javaTypes");
        this.name = name;
        this.title = Strings.isEmpty(title) ? name : title;
        this.simpleTypeKind = simpleTypeKind;
        this.jdbcType = jdbcType;
        this.javaType = javaType;
        this.javaTypes = javaTypes;
        this.defaultLength = defaultLength;
        this.defaultPrecision = defaultPrecision;
        this.defaultScale = defaultScale;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public MTypeKind getTypeKind() {
        return MTypeKind.SIMPLE;
    }

    public MSimpleTypeKind getSimpleTypeKind() {
        return this.simpleTypeKind;
    }

    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public Class<?>[] getJavaTypes() {
        return this.javaTypes;
    }

    public Integer getDefaultLength() {
        return this.defaultLength;
    }

    public Integer getDefaultPrecision() {
        return this.defaultPrecision;
    }

    public Integer getDefaultScale() {
        return this.defaultScale;
    }

    public Object valueOf(Object value) {
        if (null == value) {
            return null;
        }
        for (Class<?> cls : this.javaTypes) {
            if (!cls.isAssignableFrom(value.getClass())) continue;
            return value;
        }
        return Converts.convert(value, this.javaType);
    }

    public static class MSimpleTypeConverter
    extends AbstractConverter<MSimpleType> {
        @Override
        public boolean convertFrom(Object value, Class<?> targetType, Type genericType, Out<Object> out, ConvertContext context) throws Throwable {
            if (value instanceof CharSequence) {
                String name = value.toString();
                out.set(MSimpleTypes.forName(name));
                return true;
            }
            return false;
        }

        @Override
        public String convertToString(MSimpleType value) throws Throwable {
            return value.getName();
        }
    }
}

