/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.meta;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import leap.lang.Strings;
import leap.lang.exception.ObjectNotFoundException;
import leap.lang.jdbc.JdbcType;
import leap.lang.jdbc.JdbcTypes;
import leap.lang.meta.MSimpleType;
import leap.lang.meta.MSimpleTypeKind;
import leap.lang.reflect.Reflection;

public class MSimpleTypes {
    private static final Map<String, MSimpleType> types = new LinkedHashMap<String, MSimpleType>();
    public static final MSimpleType BINARY = MSimpleTypes.define(MSimpleTypeKind.BINARY, "binary", byte[].class, Byte[].class);
    public static final MSimpleType BOOLEAN = MSimpleTypes.define(MSimpleTypeKind.BOOLEAN, "boolean", Boolean.class, Boolean.TYPE);
    public static final MSimpleType BYTE = MSimpleTypes.define(MSimpleTypeKind.BYTE, "tinyint", Byte.class, Byte.TYPE);
    public static final MSimpleType DATETIME = MSimpleTypes.define(MSimpleTypeKind.DATETIME, "timestamp", java.util.Date.class, LocalDateTime.class, Timestamp.class, Date.class, Calendar.class);
    public static final MSimpleType DATE = MSimpleTypes.define(MSimpleTypeKind.DATE, "date", LocalDate.class, java.util.Date.class);
    public static final MSimpleType TIME = MSimpleTypes.define(MSimpleTypeKind.TIME, "time", LocalTime.class, Time.class, java.util.Date.class);
    public static final MSimpleType DECIMAL = MSimpleTypes.define(MSimpleTypeKind.DECIMAL, "decimal", (Integer)19, (Integer)4, BigDecimal.class);
    public static final MSimpleType SINGLE = MSimpleTypes.define(MSimpleTypeKind.SINGLE, "real", Float.class, Float.TYPE);
    public static final MSimpleType DOUBLE = MSimpleTypes.define(MSimpleTypeKind.DOUBLE, "double", Double.class, Double.TYPE);
    public static final MSimpleType SMALLINT = MSimpleTypes.define(MSimpleTypeKind.SMALLINT, "smallint", Short.class, Short.TYPE);
    public static final MSimpleType INTEGER = MSimpleTypes.define(MSimpleTypeKind.INTEGER, "integer", Integer.class, Integer.TYPE);
    public static final MSimpleType BIGINT = MSimpleTypes.define(MSimpleTypeKind.BIGINT, "bigint", Long.class, Long.TYPE, BigInteger.class);
    public static final MSimpleType STRING = MSimpleTypes.define(MSimpleTypeKind.STRING, "varchar", (Integer)255, String.class, StringBuilder.class, Character.TYPE, Character.class);

    public static Iterable<MSimpleType> all() {
        return types.values();
    }

    public static MSimpleType forName(String name) throws ObjectNotFoundException {
        MSimpleType t = MSimpleTypes.tryForName(name);
        if (null == t) {
            throw new ObjectNotFoundException("Simple Type '" + name + "' not found");
        }
        return t;
    }

    public static MSimpleType tryForName(String name) {
        return types.get(name.toLowerCase());
    }

    public static MSimpleType forClass(Class<?> cls) throws ObjectNotFoundException {
        MSimpleType t = MSimpleTypes.tryForClass(cls);
        if (null == t) {
            throw new ObjectNotFoundException("No simple type mapping to java class '" + cls + "'");
        }
        return t;
    }

    public static MSimpleType tryForClass(Class<?> cls) {
        if (cls.isEnum()) {
            Field field = Reflection.findField(cls, "value");
            if (null != field) {
                return MSimpleTypes.tryForClass(field.getType());
            }
            return MSimpleTypes.tryForClass(String.class);
        }
        for (MSimpleType t : MSimpleTypes.all()) {
            if (!t.getJavaType().equals(cls)) continue;
            return t;
        }
        for (MSimpleType t : MSimpleTypes.all()) {
            for (Class<?> javaType : t.getJavaTypes()) {
                if (!javaType.equals(cls)) continue;
                return t;
            }
        }
        return null;
    }

    private static MSimpleType define(MSimpleTypeKind kind, String jdbcTypeName, Class<?> ... javaTypes) {
        return MSimpleTypes.define(kind, jdbcTypeName, null, null, null, javaTypes);
    }

    private static MSimpleType define(MSimpleTypeKind kind, String jdbcTypeName, Integer defaultLength, Class<?> ... javaTypes) {
        return MSimpleTypes.define(kind, jdbcTypeName, defaultLength, (Integer)0, 0, javaTypes);
    }

    private static MSimpleType define(MSimpleTypeKind kind, String jdbcTypeName, Integer defaultPrecision, Integer defaultScale, Class<?> ... javaTypes) {
        return MSimpleTypes.define(kind, jdbcTypeName, (Integer)0, defaultPrecision, defaultScale, javaTypes);
    }

    private static MSimpleType define(MSimpleTypeKind kind, String jdbcTypeName, Integer defaultLength, Integer defaultPrecision, Integer defaultScale, Class<?> ... javaTypes) {
        String name = kind.name();
        String title = Strings.upperCamel(name);
        JdbcType jdbcType = JdbcTypes.forTypeName(jdbcTypeName);
        MSimpleType t = new MSimpleType(name, title, null, null, kind, jdbcType, javaTypes[0], javaTypes, defaultLength, defaultPrecision, defaultScale);
        types.put(name.toLowerCase(), t);
        return t;
    }

    protected MSimpleTypes() {
    }
}

