/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.meta;

import java.util.ArrayList;
import java.util.List;
import leap.lang.Args;
import leap.lang.Iterables;
import leap.lang.Predicates;
import leap.lang.exception.ObjectNotFoundException;
import leap.lang.meta.MNamedWithDescBuilder;
import leap.lang.meta.MProperty;
import leap.lang.meta.MStructuralType;

public abstract class MStructualTypeBuilder<T extends MStructuralType>
extends MNamedWithDescBuilder<T> {
    protected List<MProperty> properties = new ArrayList<MProperty>();

    public List<MProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<MProperty> properties) {
        this.properties = properties;
    }

    public MProperty getProperty(String name) throws ObjectNotFoundException {
        MProperty p = this.findProperty(name);
        if (null == p) {
            throw new ObjectNotFoundException("Property '" + name + "' not found");
        }
        return p;
    }

    public MProperty findProperty(String name) {
        return Iterables.firstOrNull(this.properties, Predicates.nameEquals(name));
    }

    public void addProperty(MProperty p) {
        Args.notNull(p, "property");
        this.properties.add(p);
    }
}

