/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.meta;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import leap.lang.Args;
import leap.lang.Factory;
import leap.lang.Strings;
import leap.lang.Types;
import leap.lang.beans.BeanProperty;
import leap.lang.beans.BeanType;
import leap.lang.meta.AbstractMTypeFactory;
import leap.lang.meta.MCollectionType;
import leap.lang.meta.MComplexType;
import leap.lang.meta.MComplexTypeBuilder;
import leap.lang.meta.MDictionaryType;
import leap.lang.meta.MObjectType;
import leap.lang.meta.MPropertyBuilder;
import leap.lang.meta.MSimpleType;
import leap.lang.meta.MSimpleTypes;
import leap.lang.meta.MType;
import leap.lang.meta.MTypeContext;
import leap.lang.meta.MTypeFactory;
import leap.lang.meta.MUnresolvedType;
import leap.lang.meta.annotation.ComplexType;
import leap.lang.meta.annotation.NonProperty;

public class SimpleMTypeFactory
extends AbstractMTypeFactory
implements MTypeFactory {
    protected static final MTypeFactory[] externalFactories = Factory.newInstances(MTypeFactory.class).toArray(new MTypeFactory[0]);
    private MTypeContext context;

    public SimpleMTypeFactory() {
    }

    public SimpleMTypeFactory(MTypeContext context) {
        this.context = context;
    }

    @Override
    public MType getMType(Class<?> type) {
        return this.getMType(type, null, this.context);
    }

    @Override
    public MType getMType(Class<?> type, Type genericType) {
        return this.getMType(type, genericType, this.context);
    }

    @Override
    public MType getMType(Class<?> declaringClass, Class<?> type, Type genericType, MTypeContext context) {
        Args.notNull(context, "context");
        MTypeFactory root = context.root();
        if (null == root) {
            root = this;
        }
        return this.getMType(context, declaringClass, type, genericType, root);
    }

    protected MType getMType(MTypeContext context, Class<?> declaringType, Class<?> type, Type genericType, MTypeFactory root) {
        Args.notNull(type, "type");
        for (MTypeFactory factory : externalFactories) {
            MType mtype = factory.getMType(declaringType, type, genericType, context);
            if (null == mtype) continue;
            return mtype;
        }
        MSimpleType mtype = MSimpleTypes.tryForClass(type);
        if (null != mtype) {
            return mtype;
        }
        if (type.isArray()) {
            return new MCollectionType(root.getMType(declaringType, type.getComponentType(), null, context));
        }
        if (Iterable.class.isAssignableFrom(type)) {
            MType elementType;
            if (null == genericType) {
                elementType = MUnresolvedType.TYPE;
            } else {
                Type typeArgument = Types.getTypeArgument(genericType);
                Class<?> elementClass = Types.getActualType(declaringType, typeArgument);
                genericType = typeArgument;
                elementType = root.getMType(elementClass, genericType, context);
            }
            return new MCollectionType(elementType);
        }
        boolean isComplexTypeAnnotated = type.isAnnotationPresent(ComplexType.class);
        if (!isComplexTypeAnnotated) {
            if (Map.class.isAssignableFrom(type)) {
                return this.getDictionaryType(context, declaringType, type, genericType, root);
            }
            if (Object.class.equals(type)) {
                return MObjectType.TYPE;
            }
        }
        return this.createComplexType(context, type, root);
    }

    protected MType getDictionaryType(MTypeContext context, Class<?> declaringType, Class<?> type, Type genericType, MTypeFactory root) {
        if (null == genericType) {
            return MDictionaryType.INSTANCE;
        }
        Type[] types = this.getDictionaryTypes(type, genericType);
        Type keyType = types[0];
        Type valType = types[1];
        MType keyMType = this.getMType(context, declaringType, Types.getActualType(keyType), keyType, root);
        MType valMType = this.getMType(context, declaringType, Types.getActualType(valType), valType, root);
        return new MDictionaryType(keyMType, valMType);
    }

    protected Type[] getDictionaryTypes(Class<?> type, Type genericType) {
        Type[] types = Types.getTypeArguments(genericType);
        if (types.length != 2) {
            Class<?> c;
            for (Type genericInterface : type.getGenericInterfaces()) {
                Class<?> c2 = Types.getActualType(genericInterface);
                if (!Map.class.isAssignableFrom(c2)) continue;
                return this.getDictionaryTypes(c2, genericInterface);
            }
            Type genericSuperClass = type.getGenericSuperclass();
            if (null != genericSuperClass && Map.class.isAssignableFrom(c = Types.getActualType(genericSuperClass))) {
                return this.getDictionaryTypes(c, genericSuperClass);
            }
        }
        return types;
    }

    protected MComplexType createComplexType(MTypeContext context, Class<?> type, MTypeFactory root) {
        MComplexTypeBuilder ct = new MComplexTypeBuilder(type);
        ct.setName(type.getSimpleName());
        ct.setAbstract(Modifier.isAbstract(type.getModifiers()));
        String name = "";
        ComplexType a = type.getAnnotation(ComplexType.class);
        if (null != a) {
            name = a.name();
        }
        if (Strings.isEmpty(name)) {
            name = context.strategy().getComplexTypeName(type);
        }
        if (!Strings.isEmpty(name)) {
            ct.setName(name);
        }
        context.onComplexTypeCreating(type, name);
        BeanType bt = BeanType.of(type);
        for (BeanProperty bp : bt.getProperties()) {
            if (!bp.isField() || bp.isAnnotationPresent(NonProperty.class)) continue;
            MPropertyBuilder mp = new MPropertyBuilder();
            mp.setName(bp.getName());
            mp.setType(root.getMType(bp.getType(), bp.getGenericType(), context));
            mp.setBeanProperty(bp);
            this.configureProperty(bp, mp);
            ct.addProperty(mp.build());
        }
        context.onComplexTypeCreated(type);
        return ct.build();
    }
}

