/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.naming;

import java.util.HashMap;
import java.util.Map;
import leap.lang.Strings;
import leap.lang.beans.BeanFactoryBase;
import leap.lang.naming.NamingStyle;

public class NamingStyles {
    protected static final Map<String, NamingStyle> styles = new HashMap<String, NamingStyle>();
    public static final NamingStyle RAW = s -> s;
    public static final NamingStyle LOWER = s -> null == s ? null : s.toLowerCase();
    public static final NamingStyle UPPER = s -> null == s ? null : s.toUpperCase();
    public static final NamingStyle LOWER_CAMEL = s -> null == s ? null : Strings.lowerCamel(s, '_');
    public static final NamingStyle UPPER_CAMEL = s -> null == s ? null : Strings.upperCamel(s, '_');
    public static final NamingStyle LOWER_UNDERSCORE = s -> null == s ? null : Strings.lowerUnderscore(s);
    public static final NamingStyle LOWER_UNDERSCORE_ = s -> {
        if (null == s) {
            return null;
        }
        return (s = Strings.lowerUnderscore(s)).indexOf(95) >= 0 ? s : s + "_";
    };
    public static final String NAME_RAW = "raw";
    public static final String NAME_LOWER = "lower";
    public static final String NAME_UPPER = "upper";
    public static final String NAME_LOWER_CAMEL = "lower_camel";
    public static final String NAME_UPPER_CAMEL = "upper_camel";
    public static final String NAME_LOWER_UNDERSCORE = "lower_underscore";
    public static final String NAME_LOWER_UNDERSCORE_ = "lower_underscore_";

    public static NamingStyle get(String name) {
        return styles.get(name);
    }

    public static NamingStyle get(String name, BeanFactoryBase factory) {
        NamingStyle ns = factory.tryGetBean(NamingStyle.class, name);
        return null == ns ? NamingStyles.get(name) : ns;
    }

    protected NamingStyles() {
    }

    static {
        styles.put(NAME_RAW, RAW);
        styles.put(NAME_LOWER, LOWER);
        styles.put(NAME_UPPER, UPPER);
        styles.put(NAME_LOWER_CAMEL, LOWER_CAMEL);
        styles.put(NAME_UPPER_CAMEL, UPPER_CAMEL);
        styles.put(NAME_LOWER_UNDERSCORE, LOWER_UNDERSCORE);
        styles.put(NAME_LOWER_UNDERSCORE_, LOWER_UNDERSCORE_);
    }
}

