/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.net;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import leap.lang.Charsets;
import leap.lang.Exceptions;
import leap.lang.New;
import leap.lang.Strings;

public class Urls {
    public static final String CLASSPATH_ONE_URL_PREFIX = "classpath:";
    public static final String CLASSPATH_ALL_URL_PREFIX = "classpath*:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String JAR_URL_SEPARATOR = "!/";
    public static final String PROTOCOL_SEPARATOR = "://";
    public static final String PROTOCOL_FILE = "file";
    public static final String PROTOCOL_JAR = "jar";
    public static final String PROTOCOL_ZIP = "zip";
    public static final String PROTOCOL_VFSZIP = "vfszip";
    public static final String PROTOCOL_VFS = "vfs";
    public static final String PROTOCOL_WSJAR = "wsjar";
    public static final String PROTOCOL_CODE_SOURCE = "code-source";

    public static String encode(String url) {
        if (null == url) {
            return url;
        }
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.wrap(e);
        }
    }

    public static String encode(String url, String charset) {
        if (null == url) {
            return url;
        }
        try {
            return URLEncoder.encode(url, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.wrap(e);
        }
    }

    public static String decode(String s) {
        if (null == s) {
            return s;
        }
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.wrap(e);
        }
    }

    public static String decode(String s, String charset) {
        if (null == s) {
            return s;
        }
        try {
            return URLDecoder.decode(s, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.wrap(e);
        }
    }

    public static boolean hasProtocolPrefix(String location) {
        return null != location && location.indexOf(58) > 0;
    }

    public static boolean isClasspath(String resourceLocation) {
        return Strings.startsWith(resourceLocation, CLASSPATH_ONE_URL_PREFIX) || Strings.startsWith(resourceLocation, CLASSPATH_ALL_URL_PREFIX);
    }

    public static String getQueryString(String uri) {
        if (null == uri) {
            return null;
        }
        int index = uri.indexOf(63);
        if (index > 0) {
            return uri.substring(index + 1);
        }
        return null;
    }

    public static String appendQueryString(String url, String queryString) {
        if (null == url) {
            return url;
        }
        int index = url.lastIndexOf(63);
        if (index < 0) {
            return url + "?" + queryString;
        }
        if (index == url.length() - 1) {
            return url + queryString;
        }
        return url + "&" + queryString;
    }

    public static String appendQueryParams(String url, String name, String value) {
        return Urls.appendQueryString(url, name + "=" + Urls.encode(value));
    }

    public static String removeQueryString(String url) {
        if (null == url) {
            return url;
        }
        int index = url.indexOf(63);
        if (index < 0) {
            return url;
        }
        return url.substring(0, index);
    }

    public static boolean isUrl(String resourceLocation) {
        if (resourceLocation == null) {
            return false;
        }
        if (resourceLocation.startsWith(CLASSPATH_ONE_URL_PREFIX)) {
            return true;
        }
        try {
            new URL(resourceLocation);
            return true;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    public static boolean isFileUrl(URL url) {
        String protocol = url.getProtocol();
        return PROTOCOL_FILE.equals(protocol) || protocol.startsWith(PROTOCOL_VFS);
    }

    public static boolean isJarUrl(URL url) {
        String protocol = url.getProtocol();
        return PROTOCOL_JAR.equals(protocol) || PROTOCOL_ZIP.equals(protocol) || PROTOCOL_WSJAR.equals(protocol) || PROTOCOL_CODE_SOURCE.equals(protocol) && url.getPath().contains(JAR_URL_SEPARATOR);
    }

    public static URI toURI(URL url) throws URISyntaxException {
        return Urls.toURI(url.toString());
    }

    public static URI toURI(String location) throws URISyntaxException {
        return new URI(Strings.replace(location, " ", "%20"));
    }

    public static URL getJarFileURL(URL jarUrl) throws MalformedURLException {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
        if (separatorIndex != -1) {
            String jarFile = urlFile.substring(0, separatorIndex);
            try {
                return new URL(jarFile);
            }
            catch (MalformedURLException ex) {
                if (!jarFile.startsWith("/")) {
                    jarFile = "/" + jarFile;
                }
                return new URL(FILE_URL_PREFIX + jarFile);
            }
        }
        return jarUrl;
    }

    public static void setUseCachesIfNecessary(URLConnection con) {
        con.setUseCaches(con.getClass().getName().startsWith("JNLP"));
    }

    public static String getQueryString(Map<String, String> map) {
        return Urls.getQueryStringBuilder(map).toString();
    }

    public static StringBuilder getQueryStringBuilder(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        if (null != map) {
            int i = 0;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (i > 0) {
                    sb.append("&");
                }
                try {
                    sb.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), Charsets.defaultCharset().name()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
                ++i;
            }
        }
        return sb;
    }

    public static Map<String, String> queryStringToMap(String queryString) {
        HashMap<String, String> map = New.hashMap();
        if (Strings.isNotEmpty(queryString)) {
            String[] kvs;
            for (String kvStr : kvs = Strings.split(queryString, '&')) {
                String k;
                int idx = kvStr.indexOf(61);
                if (idx < 0) {
                    map.put(kvStr.trim(), null);
                    continue;
                }
                if (idx >= kvStr.length()) {
                    k = kvStr.substring(0, idx);
                    map.put(k, null);
                    continue;
                }
                k = kvStr.substring(0, idx);
                String v = kvStr.substring(idx + 1);
                map.put(k, v);
            }
        }
        return map;
    }

    protected Urls() {
    }
}

