/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.path;

import java.io.File;
import java.util.LinkedList;
import leap.lang.Strings;

public class Paths {
    public static final char EXTENSION_SEPARATOR = '.';
    public static final String EXTENSION_SEPARATOR_STR = ".";
    public static final char NORMALIZED_SEPERATOR = '/';
    public static final String NORMALIZED_SEPERATOR_STR = "/";
    public static final char UNIX_SEPARATOR = '/';
    public static final String UNIX_SEPARATOR_STR = "/";
    public static final char WINDOWS_SEPARATOR = '\\';
    public static final String WINDOWS_SEPARATOR_STR = "\\";
    public static final char SYSTEM_SEPARATOR = File.separatorChar;
    public static final String SYSTEM_SEPARATOR_STR = Character.toString(File.separatorChar);
    public static final String PARENT_PATH = "..";
    public static final String CURRENT_PATH = ".";

    protected Paths() {
    }

    public static String normalize(String path) {
        int i;
        if (path == null) {
            return "";
        }
        String pathToUse = Strings.replace(path, '\\', '/');
        int prefixIndex = pathToUse.indexOf(":");
        String prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            pathToUse = pathToUse.substring(prefixIndex + 1);
        }
        if (pathToUse.startsWith("/")) {
            prefix = prefix + '/';
            pathToUse = pathToUse.substring(1);
        }
        String[] pathArray = Strings.split(pathToUse, "/", false, false);
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if (".".equals(element)) continue;
            if (PARENT_PATH.equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, PARENT_PATH);
        }
        return prefix + Strings.join(pathElements, "/");
    }

    public static String getFileName(String path) {
        if (path == null) {
            return "";
        }
        int separatorIndex = Paths.indexOfLastSeparator(path);
        return separatorIndex != -1 ? path.substring(separatorIndex + 1) : path;
    }

    public static String getFileExtension(String path) {
        if (path == null) {
            return "";
        }
        int extIndex = path.lastIndexOf(46);
        if (extIndex == -1) {
            return "";
        }
        int folderIndex = Paths.indexOfLastSeparator(path);
        if (folderIndex > extIndex) {
            return "";
        }
        return path.substring(extIndex + 1);
    }

    public static String getFileNameWithoutExtension(String filename) {
        if (null == filename) {
            return "";
        }
        int extIndex = filename.lastIndexOf(46);
        if (extIndex == -1) {
            return filename;
        }
        int folderIndex = Paths.indexOfLastSeparator(filename);
        if (folderIndex > extIndex) {
            return filename;
        }
        return filename.substring(0, extIndex);
    }

    public static String getDirPath(String filepath) {
        return Paths.doGetFullPath(filepath, true);
    }

    public static String getDirPathWithoutPrefix(String filepath) {
        return Paths.doGetPath(filepath, 1);
    }

    public static String getPrefix(String filename) {
        if (filename == null) {
            return null;
        }
        int len = Paths.getPrefixLength(filename);
        if (len < 0) {
            return null;
        }
        if (len > filename.length()) {
            return filename + '/';
        }
        return filename.substring(0, len);
    }

    public static String applyRelative(String parentPath, String relativePath) {
        if (null == parentPath) {
            return relativePath;
        }
        int separatorIndex = (parentPath = Strings.replace(parentPath, '\\', '/')).lastIndexOf("/");
        if (separatorIndex != -1) {
            String newPath = parentPath.substring(0, separatorIndex);
            if (!relativePath.startsWith("/")) {
                newPath = newPath + "/";
            }
            return newPath + relativePath;
        }
        return relativePath;
    }

    public static String prefixWithSlash(String path) {
        return null == path ? null : (!Strings.startsWith(path, "/") ? "/" + path : path);
    }

    public static String prefixWithoutSlash(String path) {
        return null == path ? null : (Strings.startsWith(path, "/") ? path.substring(1) : path);
    }

    public static String prefixAndSuffixWithSlash(String path) {
        if (Strings.isEmpty(path)) {
            return path;
        }
        if (path.startsWith("/")) {
            return Paths.suffixWithSlash(path);
        }
        return "/" + Paths.suffixWithSlash(path);
    }

    public static String prefixAndSuffixWithoutSlash(String path) {
        if (Strings.isEmpty(path)) {
            return path;
        }
        return Paths.suffixWithoutSlash(Paths.prefixWithoutSlash(path));
    }

    public static String prefixWithAndSuffixWithoutSlash(String path) {
        if (Strings.isEmpty(path)) {
            return path;
        }
        if (path.startsWith("/")) {
            return Paths.suffixWithoutSlash(path);
        }
        return "/" + Paths.suffixWithoutSlash(path);
    }

    public static String prefixWithoutAndSuffixWithSlash(String path) {
        if (Strings.isEmpty(path)) {
            return path;
        }
        if (path.endsWith("/")) {
            return Paths.prefixWithoutSlash(path);
        }
        return Paths.prefixWithoutSlash(path) + "/";
    }

    public static String suffixWithSlash(String path) {
        return !Strings.endsWith(path, "/") ? path + "/" : path;
    }

    public static String suffixWithoutSlash(String path) {
        return Strings.endsWith(path, "/") ? path.substring(0, path.length() - 1) : path;
    }

    public static boolean isExplicitRelativePath(String path) {
        return null != path && (path.startsWith("./") || path.startsWith("../") || path.startsWith(".\\") || path.startsWith("..\\"));
    }

    private static String doGetPath(String filename, int separatorAdd) {
        if (filename == null) {
            return null;
        }
        int prefix = Paths.getPrefixLength(filename);
        if (prefix < 0) {
            return null;
        }
        int index = Paths.indexOfLastSeparator(filename);
        int endIndex = index + separatorAdd;
        if (prefix >= filename.length() || index < 0 || prefix >= endIndex) {
            return "";
        }
        return filename.substring(prefix, endIndex);
    }

    private static String doGetFullPath(String filename, boolean includeSeparator) {
        if (filename == null) {
            return null;
        }
        int prefix = Paths.getPrefixLength(filename);
        if (prefix < 0) {
            return null;
        }
        if (prefix >= filename.length()) {
            if (includeSeparator) {
                return Paths.getPrefix(filename);
            }
            return filename;
        }
        int index = Paths.indexOfLastSeparator(filename);
        if (index < 0) {
            return filename.substring(0, prefix);
        }
        int end = index + (includeSeparator ? 1 : 0);
        if (end == 0) {
            ++end;
        }
        return filename.substring(0, end);
    }

    static int getPrefixLength(String filename) {
        if (filename == null) {
            return -1;
        }
        int len = filename.length();
        if (len == 0) {
            return 0;
        }
        char ch0 = filename.charAt(0);
        if (ch0 == ':') {
            return -1;
        }
        if (len == 1) {
            if (ch0 == '~') {
                return 2;
            }
            return Paths.isSeparator(ch0) ? 1 : 0;
        }
        if (ch0 == '~') {
            int posUnix = filename.indexOf(47, 1);
            int posWin = filename.indexOf(92, 1);
            if (posUnix == -1 && posWin == -1) {
                return len + 1;
            }
            posUnix = posUnix == -1 ? posWin : posUnix;
            posWin = posWin == -1 ? posUnix : posWin;
            return Math.min(posUnix, posWin) + 1;
        }
        char ch1 = filename.charAt(1);
        if (ch1 == ':') {
            if ((ch0 = Character.toUpperCase(ch0)) >= 'A' && ch0 <= 'Z') {
                if (len == 2 || !Paths.isSeparator(filename.charAt(2))) {
                    return 2;
                }
                return 3;
            }
            return -1;
        }
        if (Paths.isSeparator(ch0) && Paths.isSeparator(ch1)) {
            int posUnix = filename.indexOf(47, 2);
            int posWin = filename.indexOf(92, 2);
            if (posUnix == -1 && posWin == -1 || posUnix == 2 || posWin == 2) {
                return -1;
            }
            posUnix = posUnix == -1 ? posWin : posUnix;
            posWin = posWin == -1 ? posUnix : posWin;
            return Math.min(posUnix, posWin) + 1;
        }
        return Paths.isSeparator(ch0) ? 1 : 0;
    }

    public static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static boolean isSystemWindows() {
        return SYSTEM_SEPARATOR == '\\';
    }

    public static boolean isSeparator(char ch) {
        return ch == '/' || ch == '\\';
    }
}

