/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import leap.lang.Classes;
import leap.lang.Primitives;
import leap.lang.Strings;
import leap.lang.asm.ClassWriter;
import leap.lang.asm.Label;
import leap.lang.asm.MethodVisitor;
import leap.lang.asm.Type;
import leap.lang.reflect.ReflectAccessor;
import leap.lang.reflect.ReflectException;

public abstract class ASMReflectAccessor
implements ReflectAccessor {
    private static final String CLASS_NAME = ASMReflectAccessor.class.getName().replaceAll("\\.", "/");
    private static final String A_CLASS_NAME = "L" + CLASS_NAME + ";";
    Field[] fields;
    Method[] methods;
    Constructor<?> constructor;

    @Override
    public boolean canNewInstance() {
        return null != this.constructor;
    }

    @Override
    public int getMethodIndex(Method method) {
        int n = this.methods.length;
        for (int i = 0; i < n; ++i) {
            if (!method.equals(this.methods[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getFieldIndex(Field field) {
        int n = this.fields.length;
        for (int i = 0; i < n; ++i) {
            if (!field.equals(this.fields[i])) continue;
            return i;
        }
        return -1;
    }

    public int getFieldIndex(String name) {
        int n = this.fields.length;
        for (int i = 0; i < n; ++i) {
            if (!name.equals(this.fields[i].getName())) continue;
            return i;
        }
        return -1;
    }

    static ASMReflectAccessor createFor(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        synchronized (clazz2) {
            ReflectLoader loader = new ReflectLoader(clazz.getClassLoader());
            String typeClassName = clazz.getName();
            String accessorClassName = ASMReflectAccessor.getAccessorClassNameFor(clazz);
            Class<?> accessorClass = null;
            try {
                accessorClass = loader.loadClass(accessorClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Method[] methods = ASMReflectAccessor.getAccessibleMethods(clazz);
            Field[] fields = ASMReflectAccessor.getAccessibleFields(clazz);
            Constructor<?> c = ASMReflectAccessor.getDefaultConstructor(clazz, accessorClassName.startsWith(typeClassName));
            if (accessorClass == null) {
                String accessorClassNameInternal = accessorClassName.replace('.', '/');
                String typeClassNameInternal = typeClassName.replace('.', '/');
                ClassWriter cw = new ClassWriter(1);
                ASMReflectAccessor.defineAccessorConstructor(accessorClassNameInternal, cw);
                ASMReflectAccessor.defineNewInstance(typeClassNameInternal, cw);
                ASMReflectAccessor.defineNewArray(clazz, typeClassNameInternal, cw);
                ASMReflectAccessor.defineGetArrayLength(clazz, cw);
                ASMReflectAccessor.defineGetArrayItem(clazz, cw);
                ASMReflectAccessor.defineSetArrayItem(clazz, cw);
                ASMReflectAccessor.defineInvokeMethod(typeClassNameInternal, methods, cw);
                ASMReflectAccessor.defineSetField(typeClassNameInternal, fields, cw);
                ASMReflectAccessor.defineGetField(typeClassNameInternal, fields, cw);
                cw.visitEnd();
                byte[] data = cw.toByteArray();
                accessorClass = loader.defineClass(accessorClassName, data);
            }
            try {
                ASMReflectAccessor accessor = (ASMReflectAccessor)accessorClass.newInstance();
                accessor.methods = methods;
                accessor.fields = fields;
                accessor.constructor = c;
                return accessor;
            }
            catch (Exception ex) {
                throw new ReflectException(Strings.format("Error constructing reflect accessor class: {0}", accessorClassName), ex);
            }
        }
    }

    private static void defineAccessorConstructor(String accessorClassNameInternal, ClassWriter cw) {
        cw.visit(50, 1, accessorClassNameInternal, null, CLASS_NAME, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, CLASS_NAME, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void defineNewInstance(String classNameInternal, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "newInstance", "()Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, classNameInternal);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, classNameInternal, "<init>", "()V");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void defineNewArray(Class<?> clazz, String classNameInternal, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "newArray", "(I)Ljava/lang/Object;", null, null);
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(21, 1);
        if (clazz.isPrimitive()) {
            mv.visitIntInsn(188, ASMReflectAccessor.getPrimitiveTypeCode(clazz));
        } else {
            mv.visitTypeInsn(189, classNameInternal);
        }
        mv.visitInsn(176);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", A_CLASS_NAME, null, l0, l1, 0);
        mv.visitLocalVariable("length", "I", null, l0, l1, 1);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
    }

    private static void defineGetArrayLength(Class<?> clazz, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "getArrayLength", "(Ljava/lang/Object;)I", null, null);
        Type type = Type.getType(clazz);
        if (clazz.isPrimitive()) {
            String primitiveInternalName = null;
            switch (type.getSort()) {
                case 1: {
                    primitiveInternalName = "Z";
                    break;
                }
                case 3: {
                    primitiveInternalName = "B";
                    break;
                }
                case 2: {
                    primitiveInternalName = "C";
                    break;
                }
                case 4: {
                    primitiveInternalName = "S";
                    break;
                }
                case 5: {
                    primitiveInternalName = "I";
                    break;
                }
                case 6: {
                    primitiveInternalName = "F";
                    break;
                }
                case 7: {
                    primitiveInternalName = "J";
                    break;
                }
                case 8: {
                    primitiveInternalName = "D";
                    break;
                }
                default: {
                    throw new IllegalStateException("??? unknow primitive type '" + clazz.getName() + "'");
                }
            }
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, "[" + primitiveInternalName);
            mv.visitInsn(190);
            mv.visitInsn(172);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", A_CLASS_NAME, null, l0, l1, 0);
            mv.visitLocalVariable("array", "Ljava/lang/Object;", null, l0, l1, 1);
            mv.visitMaxs(1, 2);
            mv.visitEnd();
        } else {
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, "[Ljava/lang/Object;");
            mv.visitInsn(190);
            mv.visitInsn(172);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", A_CLASS_NAME, null, l0, l1, 0);
            mv.visitLocalVariable("array", "Ljava/lang/Object;", null, l0, l1, 1);
            mv.visitMaxs(1, 2);
            mv.visitEnd();
        }
    }

    private static void defineGetArrayItem(Class<?> clazz, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "getArrayItem", "(Ljava/lang/Object;I)Ljava/lang/Object;", null, null);
        Type type = Type.getType(clazz);
        if (clazz.isPrimitive()) {
            int opcode = -1;
            String primitiveInternalName = null;
            String wraperTypeInternalName = Type.getType(Primitives.wrap(clazz)).getInternalName();
            switch (type.getSort()) {
                case 1: {
                    opcode = 51;
                    primitiveInternalName = "Z";
                    break;
                }
                case 3: {
                    opcode = 51;
                    primitiveInternalName = "B";
                    break;
                }
                case 2: {
                    opcode = 52;
                    primitiveInternalName = "C";
                    break;
                }
                case 4: {
                    opcode = 53;
                    primitiveInternalName = "S";
                    break;
                }
                case 5: {
                    opcode = 46;
                    primitiveInternalName = "I";
                    break;
                }
                case 6: {
                    opcode = 48;
                    primitiveInternalName = "F";
                    break;
                }
                case 7: {
                    opcode = 51;
                    primitiveInternalName = "J";
                    break;
                }
                case 8: {
                    opcode = 49;
                    primitiveInternalName = "D";
                    break;
                }
                default: {
                    throw new IllegalStateException("??? unknow primitive type '" + clazz.getName() + "'");
                }
            }
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, "[" + primitiveInternalName);
            mv.visitVarInsn(21, 2);
            mv.visitInsn(opcode);
            mv.visitMethodInsn(184, wraperTypeInternalName, "valueOf", "(" + primitiveInternalName + ")L" + wraperTypeInternalName + ";");
            mv.visitInsn(176);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", A_CLASS_NAME, null, l0, l1, 0);
            mv.visitLocalVariable("array", "Ljava/lang/Object;", null, l0, l1, 1);
            mv.visitLocalVariable("index", "I", null, l0, l1, 2);
            mv.visitMaxs(2, 3);
            mv.visitEnd();
        } else {
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, "[Ljava/lang/Object;");
            mv.visitVarInsn(21, 2);
            mv.visitInsn(50);
            mv.visitInsn(176);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", A_CLASS_NAME, null, l0, l1, 0);
            mv.visitLocalVariable("array", "Ljava/lang/Object;", null, l0, l1, 1);
            mv.visitLocalVariable("index", "I", null, l0, l1, 2);
            mv.visitMaxs(2, 3);
            mv.visitEnd();
        }
    }

    private static void defineSetArrayItem(Class<?> clazz, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "setArrayItem", "(Ljava/lang/Object;ILjava/lang/Object;)V", null, null);
        Type type = Type.getType(clazz);
        if (clazz.isPrimitive()) {
            int opcode = -1;
            String primitiveInternalName = null;
            String unboxMethodName = null;
            String wraperTypeInternalName = Type.getType(Primitives.wrap(clazz)).getInternalName();
            switch (type.getSort()) {
                case 1: {
                    opcode = 84;
                    primitiveInternalName = "Z";
                    unboxMethodName = "booleanValue";
                    break;
                }
                case 3: {
                    opcode = 84;
                    primitiveInternalName = "B";
                    unboxMethodName = "byteValue";
                    break;
                }
                case 2: {
                    opcode = 85;
                    primitiveInternalName = "C";
                    unboxMethodName = "charValue";
                    break;
                }
                case 4: {
                    opcode = 86;
                    primitiveInternalName = "S";
                    unboxMethodName = "shortValue";
                    break;
                }
                case 5: {
                    opcode = 79;
                    primitiveInternalName = "I";
                    unboxMethodName = "intValue";
                    break;
                }
                case 6: {
                    opcode = 81;
                    primitiveInternalName = "F";
                    unboxMethodName = "floatValue";
                    break;
                }
                case 7: {
                    opcode = 84;
                    primitiveInternalName = "J";
                    unboxMethodName = "longValue";
                    break;
                }
                case 8: {
                    opcode = 82;
                    primitiveInternalName = "D";
                    unboxMethodName = "doubleValue";
                    break;
                }
                default: {
                    throw new IllegalStateException("??? unknow primitive type '" + clazz.getName() + "'");
                }
            }
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, "[" + primitiveInternalName);
            mv.visitVarInsn(21, 2);
            mv.visitVarInsn(25, 3);
            mv.visitTypeInsn(192, wraperTypeInternalName);
            mv.visitMethodInsn(182, wraperTypeInternalName, unboxMethodName, "()" + primitiveInternalName);
            mv.visitInsn(opcode);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitInsn(177);
            Label l2 = new Label();
            mv.visitLabel(l2);
            mv.visitLocalVariable("this", A_CLASS_NAME, null, l0, l2, 0);
            mv.visitLocalVariable("array", "Ljava/lang/Object;", null, l0, l2, 1);
            mv.visitLocalVariable("index", "I", null, l0, l2, 2);
            mv.visitLocalVariable("value", "Ljava/lang/Object;", null, l0, l2, 3);
            mv.visitMaxs(3, 4);
            mv.visitEnd();
        } else {
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, "[Ljava/lang/Object;");
            mv.visitVarInsn(21, 2);
            mv.visitVarInsn(25, 3);
            mv.visitInsn(83);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitInsn(177);
            Label l2 = new Label();
            mv.visitLabel(l2);
            mv.visitLocalVariable("this", A_CLASS_NAME, null, l0, l2, 0);
            mv.visitLocalVariable("array", "Ljava/lang/Object;", null, l0, l2, 1);
            mv.visitLocalVariable("index", "I", null, l0, l2, 2);
            mv.visitLocalVariable("value", "Ljava/lang/Object;", null, l0, l2, 3);
            mv.visitMaxs(3, 4);
            mv.visitEnd();
        }
    }

    private static void defineInvokeMethod(String classNameInternal, Method[] methods, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(129, "invokeMethod", "(Ljava/lang/Object;I[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        if (methods.length > 0) {
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, classNameInternal);
            mv.visitVarInsn(58, 4);
            mv.visitVarInsn(21, 2);
            Label[] labels = new Label[methods.length];
            for (int i = 0; i < labels.length; ++i) {
                labels[i] = new Label();
            }
            Label defaultLabel = new Label();
            mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
            StringBuilder buffer = new StringBuilder(128);
            for (int i = 0; i < labels.length; ++i) {
                mv.visitLabel(labels[i]);
                if (i == 0) {
                    mv.visitFrame(1, 1, new Object[]{classNameInternal}, 0, null);
                } else {
                    mv.visitFrame(3, 0, null, 0, null);
                }
                mv.visitVarInsn(25, 4);
                buffer.setLength(0);
                buffer.append('(');
                Method method = methods[i];
                Class<?>[] paramTypes = method.getParameterTypes();
                for (int paramIndex = 0; paramIndex < paramTypes.length; ++paramIndex) {
                    mv.visitVarInsn(25, 3);
                    mv.visitIntInsn(16, paramIndex);
                    mv.visitInsn(50);
                    Type paramType = Type.getType(paramTypes[paramIndex]);
                    switch (paramType.getSort()) {
                        case 1: {
                            mv.visitTypeInsn(192, "java/lang/Boolean");
                            mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                            break;
                        }
                        case 3: {
                            mv.visitTypeInsn(192, "java/lang/Byte");
                            mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
                            break;
                        }
                        case 2: {
                            mv.visitTypeInsn(192, "java/lang/Character");
                            mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
                            break;
                        }
                        case 4: {
                            mv.visitTypeInsn(192, "java/lang/Short");
                            mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
                            break;
                        }
                        case 5: {
                            mv.visitTypeInsn(192, "java/lang/Integer");
                            mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
                            break;
                        }
                        case 6: {
                            mv.visitTypeInsn(192, "java/lang/Float");
                            mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
                            break;
                        }
                        case 7: {
                            mv.visitTypeInsn(192, "java/lang/Long");
                            mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
                            break;
                        }
                        case 8: {
                            mv.visitTypeInsn(192, "java/lang/Double");
                            mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
                            break;
                        }
                        case 9: {
                            mv.visitTypeInsn(192, paramType.getDescriptor());
                            break;
                        }
                        case 10: {
                            mv.visitTypeInsn(192, paramType.getInternalName());
                        }
                    }
                    buffer.append(paramType.getDescriptor());
                }
                buffer.append(')');
                buffer.append(Type.getDescriptor(method.getReturnType()));
                mv.visitMethodInsn(182, classNameInternal, method.getName(), buffer.toString());
                switch (Type.getType(method.getReturnType()).getSort()) {
                    case 0: {
                        mv.visitInsn(1);
                        break;
                    }
                    case 1: {
                        mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                        break;
                    }
                    case 3: {
                        mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                        break;
                    }
                    case 2: {
                        mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                        break;
                    }
                    case 4: {
                        mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                        break;
                    }
                    case 5: {
                        mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                        break;
                    }
                    case 6: {
                        mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                        break;
                    }
                    case 7: {
                        mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                        break;
                    }
                    case 8: {
                        mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                    }
                }
                mv.visitInsn(176);
            }
            mv.visitLabel(defaultLabel);
            mv.visitFrame(3, 0, null, 0, null);
        }
        mv.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        mv.visitInsn(89);
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitLdcInsn("Method not found: ");
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V");
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
        mv.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void defineSetField(String classNameInternal, Field[] fields, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "setFieldValue", "(Ljava/lang/Object;ILjava/lang/Object;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(21, 2);
        if (fields.length > 0) {
            Label[] labels = new Label[fields.length];
            int n = labels.length;
            for (int i = 0; i < n; ++i) {
                labels[i] = new Label();
            }
            Label defaultLabel = new Label();
            mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
            int n2 = labels.length;
            for (int i = 0; i < n2; ++i) {
                Field field = fields[i];
                Type fieldType = Type.getType(field.getType());
                mv.visitLabel(labels[i]);
                mv.visitFrame(3, 0, null, 0, null);
                mv.visitVarInsn(25, 1);
                mv.visitTypeInsn(192, classNameInternal);
                mv.visitVarInsn(25, 3);
                switch (fieldType.getSort()) {
                    case 1: {
                        mv.visitTypeInsn(192, "java/lang/Boolean");
                        mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                        break;
                    }
                    case 3: {
                        mv.visitTypeInsn(192, "java/lang/Byte");
                        mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
                        break;
                    }
                    case 2: {
                        mv.visitTypeInsn(192, "java/lang/Character");
                        mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
                        break;
                    }
                    case 4: {
                        mv.visitTypeInsn(192, "java/lang/Short");
                        mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
                        break;
                    }
                    case 5: {
                        mv.visitTypeInsn(192, "java/lang/Integer");
                        mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
                        break;
                    }
                    case 6: {
                        mv.visitTypeInsn(192, "java/lang/Float");
                        mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
                        break;
                    }
                    case 7: {
                        mv.visitTypeInsn(192, "java/lang/Long");
                        mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
                        break;
                    }
                    case 8: {
                        mv.visitTypeInsn(192, "java/lang/Double");
                        mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
                        break;
                    }
                    case 9: {
                        mv.visitTypeInsn(192, fieldType.getDescriptor());
                        break;
                    }
                    case 10: {
                        mv.visitTypeInsn(192, fieldType.getInternalName());
                    }
                }
                if (Modifier.isStatic(field.getModifiers())) {
                    mv.visitFieldInsn(179, classNameInternal, field.getName(), fieldType.getDescriptor());
                } else {
                    mv.visitFieldInsn(181, classNameInternal, field.getName(), fieldType.getDescriptor());
                }
                mv.visitInsn(177);
            }
            mv.visitLabel(defaultLabel);
            mv.visitFrame(3, 0, null, 0, null);
        }
        mv.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        mv.visitInsn(89);
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitLdcInsn("Field not found: ");
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V");
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
        mv.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void defineGetField(String classNameInternal, Field[] fields, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "getFieldValue", "(Ljava/lang/Object;I)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(21, 2);
        if (fields.length > 0) {
            Label[] labels = new Label[fields.length];
            int n = labels.length;
            for (int i = 0; i < n; ++i) {
                labels[i] = new Label();
            }
            Label defaultLabel = new Label();
            mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
            int n2 = labels.length;
            for (int i = 0; i < n2; ++i) {
                Field field = fields[i];
                mv.visitLabel(labels[i]);
                mv.visitFrame(3, 0, null, 0, null);
                mv.visitVarInsn(25, 1);
                mv.visitTypeInsn(192, classNameInternal);
                if (Modifier.isStatic(field.getModifiers())) {
                    mv.visitFieldInsn(178, classNameInternal, field.getName(), Type.getDescriptor(field.getType()));
                } else {
                    mv.visitFieldInsn(180, classNameInternal, field.getName(), Type.getDescriptor(field.getType()));
                }
                Type fieldType = Type.getType(field.getType());
                switch (fieldType.getSort()) {
                    case 1: {
                        mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                        break;
                    }
                    case 3: {
                        mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                        break;
                    }
                    case 2: {
                        mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                        break;
                    }
                    case 4: {
                        mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                        break;
                    }
                    case 5: {
                        mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                        break;
                    }
                    case 6: {
                        mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                        break;
                    }
                    case 7: {
                        mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                        break;
                    }
                    case 8: {
                        mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                    }
                }
                mv.visitInsn(176);
            }
            mv.visitLabel(defaultLabel);
            mv.visitFrame(3, 0, null, 0, null);
        }
        mv.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        mv.visitInsn(89);
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitLdcInsn("Field not found: ");
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V");
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
        mv.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static Constructor<?> getDefaultConstructor(Class<?> type, boolean isPackageAccessible) {
        for (Constructor<?> c : type.getDeclaredConstructors()) {
            int modifiers = c.getModifiers();
            if (c.getParameterTypes().length != 0) continue;
            if (Modifier.isPrivate(modifiers)) {
                return null;
            }
            if (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers)) {
                return c;
            }
            if (isPackageAccessible) {
                return c;
            }
            return null;
        }
        return null;
    }

    private static Method[] getAccessibleMethods(Class<?> type) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> nextClass = type; nextClass != null && nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
            for (Method method : nextClass.getDeclaredMethods()) {
                if (Modifier.isPrivate(method.getModifiers())) continue;
                methods.add(method);
            }
        }
        return methods.toArray(new Method[methods.size()]);
    }

    private static Field[] getAccessibleFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        String typePackageName = Classes.getPackageName(type);
        HashSet<String> processed = new HashSet<String>();
        for (Class<?> nextClass = type; nextClass != null && nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
            for (Field field : nextClass.getDeclaredFields()) {
                String nextClassPackageName;
                if (processed.contains(field.getName())) continue;
                processed.add(field.getName());
                if (Modifier.isPrivate(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || field.isSynthetic() || !Modifier.isPublic(field.getModifiers()) && (type.getPackage() == null || type != nextClass && !Strings.equals(typePackageName, nextClassPackageName = Classes.getPackageName(nextClass)))) continue;
                fields.add(field);
            }
        }
        return fields.toArray(new Field[fields.size()]);
    }

    private static int getPrimitiveTypeCode(Class<?> primitiveType) {
        int typeCode;
        Type type = Type.getType(primitiveType);
        switch (type.getSort()) {
            case 1: {
                typeCode = 4;
                break;
            }
            case 2: {
                typeCode = 5;
                break;
            }
            case 3: {
                typeCode = 8;
                break;
            }
            case 4: {
                typeCode = 9;
                break;
            }
            case 5: {
                typeCode = 10;
                break;
            }
            case 6: {
                typeCode = 6;
                break;
            }
            case 7: {
                typeCode = 11;
                break;
            }
            case 8: {
                typeCode = 7;
                break;
            }
            default: {
                throw new IllegalStateException("not a primitive type");
            }
        }
        return typeCode;
    }

    private static String getAccessorClassNameFor(Class<?> clazz) {
        String className = clazz.getName();
        if (className.startsWith("java.") || className.startsWith("javax.")) {
            className = "leap." + className;
        }
        return className + "$LeapReflectAccessor";
    }

    static final class ReflectLoader
    extends ClassLoader {
        ReflectLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.equals(ASMReflectAccessor.class.getName())) {
                return ASMReflectAccessor.class;
            }
            return super.loadClass(name, resolve);
        }

        Class<?> defineClass(String name, byte[] bytes) throws ClassFormatError {
            try {
                Method method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                method.setAccessible(true);
                return (Class)method.invoke((Object)this.getParent(), name, bytes, new Integer(0), new Integer(bytes.length));
            }
            catch (Exception exception) {
                return this.defineClass(name, bytes, 0, bytes.length);
            }
        }
    }
}

