/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import leap.lang.Arrays2;
import leap.lang.Assert;
import leap.lang.Named;
import leap.lang.exception.ObjectNotFoundException;
import leap.lang.reflect.ReflectException;

public class ReflectAnnotation {
    private final Class<?> type;
    private AElement[] elements;

    public static ReflectAnnotation of(Class<?> annotationType) {
        Assert.isTrue(annotationType.isAnnotation(), "Not an annotation type");
        return new ReflectAnnotation(annotationType);
    }

    private ReflectAnnotation(Class<?> annotationType) {
        this.type = annotationType;
    }

    public AElement getElement(String name) throws ObjectNotFoundException {
        AElement e = this.tryGetElement(name);
        if (null == e) {
            throw new ObjectNotFoundException("Annotation element '" + name + "' not found in type '" + this.type.getName() + "'");
        }
        return e;
    }

    public AElement tryGetElement(String name) {
        this.initElements();
        for (AElement e : this.elements) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    public AElement[] getElements() {
        this.initElements();
        return this.elements;
    }

    public AElement getValueElement() throws ObjectNotFoundException {
        return this.getElement("value");
    }

    public AElement tryGetValueElement() {
        return this.tryGetElement("value");
    }

    protected void initElements() {
        if (null == this.elements) {
            ArrayList<AElement> list = new ArrayList<AElement>();
            for (Method m : this.type.getDeclaredMethods()) {
                if (!Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers()) || m.getParameterTypes().length != 0) continue;
                list.add(new AElement(m));
            }
            this.elements = list.toArray(new AElement[list.size()]);
        }
    }

    public static class AElement
    implements Named {
        private final Method m;

        private AElement(Method m) {
            this.m = m;
        }

        @Override
        public String getName() {
            return this.m.getName();
        }

        public Class<?> getType() {
            return this.m.getReturnType();
        }

        public Object getValue(Object annotation) {
            try {
                return this.m.invoke(annotation, Arrays2.EMPTY_OBJECT_ARRAY);
            }
            catch (Exception e) {
                throw new ReflectException(e.getMessage(), e);
            }
        }
    }
}

