/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import leap.lang.Arrays2;
import leap.lang.Classes;
import leap.lang.Named;
import leap.lang.Predicates;
import leap.lang.Strings;
import leap.lang.reflect.ReflectAccessor;
import leap.lang.reflect.ReflectConstructor;
import leap.lang.reflect.ReflectException;
import leap.lang.reflect.ReflectField;
import leap.lang.reflect.ReflectMember;
import leap.lang.reflect.ReflectMethod;
import leap.lang.reflect.Reflection;

public class ReflectClass
implements Named {
    protected static final Map<Class<?>, ReflectClass> cache = new ConcurrentHashMap();
    private final Class<?> clazz;
    private final ReflectAccessor accessor;
    private final boolean innerClass;
    private ReflectConstructor[] constructors;
    private ReflectField[] fields;
    private ReflectMethod[] methods;
    private ReflectField[] declaredFields;
    private ReflectMethod[] declaredMethods;
    private ReflectConstructor defaultConstructor;
    private boolean defaultConstructorInner = false;

    public static ReflectClass of(Class<?> clazz) {
        ReflectClass rclass = cache.get(clazz);
        if (null == rclass) {
            rclass = new ReflectClass(clazz);
            cache.put(clazz, rclass);
        }
        return rclass;
    }

    protected ReflectClass(Class<?> clazz) {
        this.clazz = clazz;
        this.accessor = Reflection.factory().createAccessor(this.clazz);
        this.innerClass = Classes.isInnerClass(clazz);
        this.initialize();
    }

    @Override
    public String getName() {
        return this.clazz.getName();
    }

    public boolean hasDefaultConstructor() {
        return null != this.defaultConstructor;
    }

    public <T> T newInstance() throws ReflectException {
        if (null == this.defaultConstructor) {
            throw new ReflectException(Strings.format("there is no default constructor available in class '{0}'", this.getName()));
        }
        if (this.defaultConstructorInner) {
            return this.defaultConstructor.newInstance(Reflection.newInstance(this.clazz.getEnclosingClass()));
        }
        if (null != this.accessor && this.accessor.canNewInstance()) {
            return (T)this.accessor.newInstance();
        }
        return this.defaultConstructor.newInstance(null);
    }

    public <T> T[] newArray(int length) {
        return null != this.accessor ? (Object[])this.accessor.newArray(length) : (Object[])Array.newInstance(this.clazz, length);
    }

    public int getArrayLength(Object array) {
        return null != this.accessor ? this.accessor.getArrayLength(array) : Array.getLength(array);
    }

    public Object getArrayItem(Object array, int index) {
        return null != this.accessor ? this.accessor.getArrayItem(array, index) : Array.get(array, index);
    }

    public void setArrayItem(Object array, int index, Object value) {
        if (null != this.accessor) {
            this.accessor.setArrayItem(array, index, value);
        } else {
            Array.set(array, index, value);
        }
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom(this.clazz);
    }

    public boolean isArray() {
        return this.clazz.isArray();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.clazz.getModifiers());
    }

    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    public boolean isEnum() {
        return this.clazz.isEnum();
    }

    public boolean isConcrete() {
        return !this.clazz.isInterface() && !this.isAbstract();
    }

    public boolean isInnerClass() {
        return this.innerClass;
    }

    public Class<?> getReflectedClass() {
        return this.clazz;
    }

    public Annotation[] getAnnotations() {
        return this.clazz.getAnnotations();
    }

    public ReflectConstructor[] getConstructors() {
        return this.constructors;
    }

    public ReflectConstructor getDefaultConstructor() {
        return this.defaultConstructor;
    }

    public ReflectConstructor getConstructor(Class<?> ... parameterTypes) {
        if (null == parameterTypes || parameterTypes.length == 0) {
            return this.defaultConstructor;
        }
        for (ReflectConstructor c : this.constructors) {
            Constructor<?> jc = c.getReflectedConstructor();
            if (jc.getParameterTypes().length != parameterTypes.length) continue;
            boolean match = true;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (jc.getParameterTypes()[i].equals(parameterTypes[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return c;
        }
        return null;
    }

    public ReflectField[] getFields() {
        return this.fields;
    }

    public ReflectField[] getDeclaredFields() {
        return this.declaredFields;
    }

    public ReflectField getField(final String name) {
        return Arrays2.firstOrNull(this.fields, new Predicate<ReflectField>(){

            @Override
            public boolean test(ReflectField object) {
                return object.getName().equals(name);
            }
        });
    }

    public ReflectField getField(String name, Class<?> fieldType) {
        return Arrays2.firstOrNull(this.fields, Predicates.nameEquals(name));
    }

    public ReflectField getFieldIgnorecase(String name) {
        return Arrays2.firstOrNull(this.fields, Predicates.nameEqualsIgnoreCase(name));
    }

    public ReflectMethod[] getMethods() {
        return this.methods;
    }

    public ReflectMethod[] getDeclaredMethods() {
        return this.declaredMethods;
    }

    public ReflectMethod getMethod(String name) {
        return Arrays2.firstOrNull(this.methods, Predicates.nameEquals(name));
    }

    public ReflectMethod getMethod(Method m) {
        for (ReflectMethod rm : this.methods) {
            if (!rm.getReflectedMethod().equals(m)) continue;
            return rm;
        }
        return null;
    }

    public ReflectMethod getMethod(String name, Class<?> ... argumentTypes) {
        for (ReflectMethod rm : this.methods) {
            if (!rm.getName().equals(name)) continue;
            Method m = rm.getReflectedMethod();
            if (null == argumentTypes || argumentTypes.length == 0) {
                if (m.getParameterTypes().length != 0) break;
                return rm;
            }
            if (m.getParameterTypes().length != argumentTypes.length) continue;
            boolean matched = true;
            for (int i = 0; i < m.getParameterTypes().length; ++i) {
                if (argumentTypes[i] == null || m.getParameterTypes()[i].equals(argumentTypes[i])) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return rm;
        }
        return null;
    }

    public ReflectMethod getMethod(String name, Class<?> returnType, Class<?> ... argumentTypes) {
        ReflectMethod m = this.getMethod(name, argumentTypes);
        return null == m ? null : (m.getReflectedMethod().getReturnType().equals(returnType) ? m : null);
    }

    public ReflectMethod[] getMethods(final String name) {
        return Arrays2.filter(this.methods, new Predicate<ReflectMethod>(){

            @Override
            public boolean test(ReflectMethod object) {
                return object.getName().equals(name);
            }
        }).toArray(new ReflectMethod[0]);
    }

    ReflectAccessor getAccessor() {
        return this.accessor;
    }

    private void initialize() {
        this.createConstructors();
        this.createMethods();
        this.createFields();
    }

    private void createConstructors() {
        ArrayList<ReflectConstructor> constructorList = new ArrayList<ReflectConstructor>();
        Constructor<?>[] constructors = this.clazz.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> c = constructors[i];
            if (c.isSynthetic()) continue;
            ReflectConstructor rc = new ReflectConstructor(this, c);
            constructorList.add(rc);
            if (this.innerClass && !Modifier.isStatic(this.clazz.getModifiers())) {
                if (c.getParameterTypes().length != 1 || !c.getParameterTypes()[0].equals(this.clazz.getEnclosingClass())) continue;
                this.defaultConstructor = rc;
                this.defaultConstructorInner = true;
                continue;
            }
            if (c.getParameterTypes().length != 0) continue;
            this.defaultConstructor = rc;
        }
        this.constructors = constructorList.toArray(new ReflectConstructor[constructorList.size()]);
    }

    private void createFields() {
        ArrayList<ReflectField> fieldList = new ArrayList<ReflectField>();
        for (Field f : Reflection.getFields(this.clazz)) {
            fieldList.add(new ReflectField(this, f));
        }
        this.fields = fieldList.toArray(new ReflectField[fieldList.size()]);
        this.declaredFields = ReflectClass.getDeclaredMembers(fieldList).toArray(new ReflectField[0]);
    }

    private void createMethods() {
        ArrayList<ReflectMethod> methodList = new ArrayList<ReflectMethod>();
        for (Method m : Reflection.getMethods(this.clazz)) {
            if (Object.class.equals(m.getDeclaringClass())) continue;
            methodList.add(new ReflectMethod(this, m));
        }
        this.methods = methodList.toArray(new ReflectMethod[methodList.size()]);
        this.declaredMethods = ReflectClass.getDeclaredMembers(methodList).toArray(new ReflectMethod[0]);
    }

    public String toString() {
        return this.clazz.toString();
    }

    private static <T extends ReflectMember, E> List<T> getDeclaredMembers(List<T> members) {
        return members.stream().filter(m -> m.isDeclared()).collect(Collectors.toList());
    }
}

