/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import leap.lang.Strings;
import leap.lang.reflect.ReflectClass;
import leap.lang.reflect.ReflectException;
import leap.lang.reflect.ReflectMember;
import leap.lang.reflect.ReflectParameter;
import leap.lang.reflect.Reflection;

public class ReflectConstructor
extends ReflectMember {
    private final Constructor<?> reflectedConstructor;
    private ReflectParameter[] parameters;

    protected ReflectConstructor(ReflectClass reflectiveClass, Constructor<?> javaConstructor) {
        super(reflectiveClass, javaConstructor);
        this.reflectedConstructor = javaConstructor;
        this.initialize();
    }

    @Override
    public String getName() {
        return this.reflectedConstructor.getName();
    }

    public ReflectParameter[] getParameters() {
        return this.parameters;
    }

    public Constructor<?> getReflectedConstructor() {
        return this.reflectedConstructor;
    }

    public <T> T newInstance(Object ... args) {
        try {
            return (T)this.reflectedConstructor.newInstance(args);
        }
        catch (Exception e) {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < this.parameters.length; ++i) {
                if (i > 0) {
                    s.append(',');
                }
                s.append(this.parameters[i].getName());
            }
            throw new ReflectException(Strings.format("Error newInstance in constructor '{0}({1})'", this.getDeclaringClass().getSimpleName(), s.toString()), e);
        }
    }

    private void initialize() {
        block5: {
            this.setAccessible();
            this.parameters = new ReflectParameter[this.reflectedConstructor.getParameterTypes().length];
            if (this.parameters.length <= 0) break block5;
            String[] names = Reflection.getParameterNames(this.reflectedConstructor);
            if (null == names) {
                names = ReflectConstructor.createUnknownParameterNames(this.parameters.length);
            }
            if (this.reflectedConstructor.getDeclaringClass().isEnum() && this.reflectedConstructor.getGenericParameterTypes().length != this.parameters.length) {
                for (int i = 0; i < this.parameters.length; ++i) {
                    Parameter p = this.reflectedConstructor.getParameters()[i];
                    Type genericType = null;
                    genericType = i < 2 ? p.getType() : this.reflectedConstructor.getGenericParameterTypes()[i - 2];
                    this.parameters[i] = new ReflectParameter(i + 1, names[i], this.reflectedConstructor.getParameters()[i], genericType);
                }
            } else {
                for (int i = 0; i < this.parameters.length; ++i) {
                    this.parameters[i] = new ReflectParameter(i + 1, names[i], this.reflectedConstructor.getParameters()[i], this.reflectedConstructor.getGenericParameterTypes()[i]);
                }
            }
        }
    }

    private void setAccessible() {
        try {
            this.reflectedConstructor.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.reflectedConstructor.toString();
    }

    private static String[] createUnknownParameterNames(int length) {
        String[] names = new String[length];
        for (int i = 0; i < length; ++i) {
            names[i] = "arg" + (i + 1);
        }
        return names;
    }
}

