/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.reflect;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import leap.lang.Args;
import leap.lang.reflect.ReflectClass;
import leap.lang.reflect.ReflectField;

public class ReflectEnum {
    private static final String VALUE_FIELD_NAME = "value";
    private static final Map<Class<?>, ReflectEnum> cache = Collections.synchronizedMap(new WeakHashMap());
    private final ReflectClass reflectiveClass;
    private ReflectField valueField;
    private Class<?> valueType;
    private boolean hasValueField;
    private Field[] enumConstantFields;

    public static ReflectEnum of(Class<?> enumType) {
        Args.notNull(enumType, "enumType");
        Args.assertTrue(enumType.isEnum(), "'" + enumType.getName() + "' is not an enum type");
        ReflectEnum reflectEnum = cache.get(enumType);
        if (null == reflectEnum) {
            reflectEnum = new ReflectEnum(enumType);
            cache.put(enumType, reflectEnum);
        }
        return reflectEnum;
    }

    protected ReflectEnum(Class<?> enumClass) {
        this.reflectiveClass = ReflectClass.of(enumClass);
        this.initialize();
    }

    public boolean isValued() {
        return this.hasValueField;
    }

    public Class<?> getValueType() {
        return this.valueType;
    }

    public Object getValue(Object enumConstant) {
        return null != this.valueField ? this.valueField.getValue(enumConstant) : enumConstant.toString();
    }

    public Enum<?>[] getEnumConstants() {
        return (Enum[])this.reflectiveClass.getReflectedClass().getEnumConstants();
    }

    public Field[] getEnumConstantFields() {
        if (null == this.enumConstantFields) {
            Enum[] enums = (Enum[])this.reflectiveClass.getReflectedClass().getEnumConstants();
            this.enumConstantFields = new Field[enums.length];
            for (int i = 0; i < enums.length; ++i) {
                this.enumConstantFields[i] = this.reflectiveClass.getField(enums[i].name()).getReflectedField();
            }
        }
        return this.enumConstantFields;
    }

    private void initialize() {
        this.valueField = this.reflectiveClass.getField(VALUE_FIELD_NAME);
        this.hasValueField = null != this.valueField;
        this.valueType = this.hasValueField ? this.valueField.getType() : null;
    }
}

