/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.reflect;

import leap.lang.Factory;
import leap.lang.reflect.ReflectAccessor;
import leap.lang.reflect.ReflectFactory;
import leap.lang.reflect.ReflectStrategy;

public abstract class ReflectFactoryBase
implements ReflectFactory {
    protected static ReflectStrategy strategy = Factory.newInstance(ReflectStrategy.class, DefaultReflectionStrategy.class);

    @Override
    public final ReflectAccessor createAccessor(Class<?> clazz) {
        if (strategy.canCreateAccessor(clazz)) {
            return this.doCreateAccessor(clazz);
        }
        return null;
    }

    protected abstract ReflectAccessor doCreateAccessor(Class<?> var1);

    public static class DefaultReflectionStrategy
    implements ReflectStrategy {
        @Override
        public boolean canCreateAccessor(Class<?> clazz) {
            if (clazz.isAnonymousClass()) {
                return false;
            }
            if (clazz.isSynthetic()) {
                return false;
            }
            String className = clazz.getName();
            return !className.startsWith("java") && !className.startsWith("sun.");
        }
    }
}

