/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import leap.lang.Arrays2;
import leap.lang.Classes;
import leap.lang.Primitives;
import leap.lang.Strings;
import leap.lang.reflect.ReflectAccessor;
import leap.lang.reflect.ReflectClass;
import leap.lang.reflect.ReflectException;
import leap.lang.reflect.ReflectMember;
import leap.lang.reflect.ReflectMethod;
import leap.lang.reflect.ReflectValued;

public class ReflectField
extends ReflectMember
implements ReflectValued {
    private final Field field;
    private final Class<?> type;
    private final ReflectMethod setter;
    private final ReflectMethod getter;
    private final int fieldAccessorIndex;
    private final int setterAccessorIndex;
    private final int getterAccessorIndex;
    private final ReflectAccessor accessor;

    protected ReflectField(ReflectClass reflectiveClass, Field field) {
        super(reflectiveClass, field);
        this.field = field;
        this.type = field.getType();
        this.setter = this.findSetter();
        this.getter = this.findGetter();
        this.accessor = reflectiveClass.getAccessor();
        if (null != this.setter) {
            this.setter.setSetterOf(this);
        }
        if (null != this.getter) {
            this.getter.setGetterOf(this);
        }
        this.fieldAccessorIndex = null == this.accessor ? -1 : this.accessor.getFieldIndex(field);
        this.setterAccessorIndex = null == this.setter || null == this.accessor ? -1 : this.accessor.getMethodIndex(this.setter.getReflectedMethod());
        this.getterAccessorIndex = null == this.getter || null == this.accessor ? -1 : this.accessor.getMethodIndex(this.getter.getReflectedMethod());
        this.initialize();
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Type getGenericType() {
        return this.field.getGenericType();
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.field.getAnnotations();
    }

    public Field getReflectedField() {
        return this.field;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.field.isAnnotationPresent(annotationType);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return this.field.getAnnotation(annotationType);
    }

    public boolean isSynthetic() {
        return this.field.isSynthetic();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.field.getModifiers());
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.field.getModifiers());
    }

    public boolean hasGetter() {
        return null != this.getter;
    }

    public boolean hasSetter() {
        return null != this.setter;
    }

    public ReflectMethod getGetter() {
        return this.getter;
    }

    public ReflectMethod getSetter() {
        return this.setter;
    }

    public boolean isPublicGet() {
        return Modifier.isPublic(this.field.getModifiers()) || null != this.getter && this.getter.isPublic();
    }

    public boolean isPublicSet() {
        return Modifier.isPublic(this.field.getModifiers()) || null != this.setter && this.setter.isPublic();
    }

    public boolean isPublicGetSet() {
        return Modifier.isPublic(this.field.getModifiers()) || null != this.setter && this.setter.isPublic() && null != this.getter && this.getter.isPublic();
    }

    @Override
    public void setValue(Object instance, Object value) {
        this.setValue(instance, value, false);
    }

    public void setValue(Object instance, Object value, boolean useSetter) {
        try {
            if (this.field.isSynthetic() || this.isFinal()) {
                this.field.set(instance, this.safeValue(value));
            } else if (useSetter && null != this.setter) {
                if (this.setterAccessorIndex != -1) {
                    this.accessor.invokeMethod(instance, this.setterAccessorIndex, this.safeValue(value));
                } else {
                    this.setter.invoke(instance, this.safeValue(value));
                }
            } else if (this.fieldAccessorIndex != -1) {
                this.accessor.setFieldValue(instance, this.fieldAccessorIndex, this.safeValue(value));
            } else {
                this.field.set(instance, this.safeValue(value));
            }
        }
        catch (Exception e) {
            throw new ReflectException(Strings.format("Error setting value '{0}' to field '{1}'", value, this.getName()), e);
        }
    }

    @Override
    public Object getValue(Object instance) {
        return this.getValue(instance, false);
    }

    public Object getValue(Object instance, boolean useGetter) {
        try {
            if (useGetter && null != this.getter) {
                if (this.getterAccessorIndex != -1) {
                    return this.accessor.invokeMethod(instance, this.getterAccessorIndex, Arrays2.EMPTY_OBJECT_ARRAY);
                }
                return this.getter.invoke(instance, Arrays2.EMPTY_OBJECT_ARRAY);
            }
            if (this.fieldAccessorIndex != -1) {
                return this.accessor.getFieldValue(instance, this.fieldAccessorIndex);
            }
            return this.field.get(instance);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ReflectException(Strings.format("Error getting value of field '{0}'", this.getName()), e);
        }
    }

    private void initialize() {
        this.setAccessiable();
    }

    private ReflectMethod findSetter() {
        String fieldName = this.field.getName().startsWith("_") ? this.field.getName().substring(1) : this.field.getName();
        String nameToFind = "set" + Character.toUpperCase(fieldName.charAt(0)) + (fieldName.length() > 1 ? fieldName.substring(1) : "");
        Class<?> fieldType = Primitives.wrap(this.field.getType());
        ReflectMethod m = this.findSetter(fieldType, nameToFind);
        if (null == m && Classes.isBoolean(fieldType) && fieldName.startsWith("is") && fieldName.length() > 2) {
            nameToFind = "set" + Character.toUpperCase(fieldName.charAt(2)) + (fieldName.length() > 3 ? fieldName.substring(3) : "");
            m = this.findSetter(fieldType, nameToFind);
        }
        if (null == m) {
            m = this.findSetter(fieldType, fieldName);
        }
        return m;
    }

    private ReflectMethod findSetter(Class<?> fieldType, String nameToFind) {
        for (ReflectMethod rm : this.reflectClass.getMethods()) {
            Method m = rm.getReflectedMethod();
            if (m.getParameterTypes().length != 1 || !fieldType.isAssignableFrom(Primitives.wrap(m.getParameterTypes()[0])) || !m.getName().equals(nameToFind)) continue;
            return rm;
        }
        return null;
    }

    private ReflectMethod findGetter() {
        String fieldName = this.field.getName().startsWith("_") ? this.field.getName().substring(1) : this.field.getName();
        String nameToFind = "get" + Character.toUpperCase(fieldName.charAt(0)) + (fieldName.length() > 1 ? fieldName.substring(1) : "");
        Class<?> fieldType = Primitives.wrap(this.field.getType());
        ReflectMethod m = this.findGetter(fieldType, nameToFind);
        if (null == m && Classes.isBoolean(fieldType)) {
            if (fieldName.startsWith("is") && fieldName.length() > 2) {
                if (Boolean.class.equals(this.field.getType()) && null != (m = this.findGetter(fieldType, nameToFind = "get" + Strings.upperFirst(fieldName.substring(2))))) {
                    return m;
                }
                nameToFind = fieldName;
            } else {
                nameToFind = "is" + Character.toUpperCase(fieldName.charAt(0)) + (fieldName.length() > 1 ? fieldName.substring(1) : "");
            }
            m = this.findGetter(fieldType, nameToFind);
        }
        return m;
    }

    private ReflectMethod findGetter(Class<?> fieldType, String nameToFind) {
        for (ReflectMethod rm : this.reflectClass.getMethods()) {
            Method m = rm.getReflectedMethod();
            if (m.getParameterTypes().length != 0 || !Primitives.wrap(m.getReturnType()).isAssignableFrom(fieldType) || !m.getName().equals(nameToFind)) continue;
            return rm;
        }
        return null;
    }

    private void setAccessiable() {
        try {
            if (!this.field.isAccessible()) {
                this.field.setAccessible(true);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private Object safeValue(Object value) {
        if (null == value) {
            return Classes.getDefaultValue(this.type);
        }
        return value;
    }

    public String toString() {
        return this.field.toString();
    }
}

