/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.reflect;

import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import leap.lang.Named;
import leap.lang.reflect.ReflectClass;

abstract class ReflectMember
implements Named {
    protected final Class<?> declaringClass;
    protected final ReflectClass reflectClass;
    protected final boolean declared;
    protected final boolean isPublic;

    protected ReflectMember(ReflectClass reflectClass, Member member) {
        this.declaringClass = member.getDeclaringClass();
        this.reflectClass = reflectClass;
        this.declared = member.getDeclaringClass() == reflectClass.getReflectedClass();
        this.isPublic = Modifier.isPublic(member.getModifiers());
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public ReflectClass getReflectClass() {
        return this.reflectClass;
    }

    public boolean isDeclared() {
        return this.declared;
    }

    public boolean isPublic() {
        return this.isPublic;
    }
}

