/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import leap.lang.Classes;
import leap.lang.Strings;
import leap.lang.reflect.ReflectAccessor;
import leap.lang.reflect.ReflectClass;
import leap.lang.reflect.ReflectException;
import leap.lang.reflect.ReflectField;
import leap.lang.reflect.ReflectMember;
import leap.lang.reflect.ReflectParameter;
import leap.lang.reflect.Reflection;

public class ReflectMethod
extends ReflectMember {
    private final ReflectAccessor accessor;
    private final int accessorIndex;
    private final Method reflectedMethod;
    private ReflectParameter[] parameters;
    private boolean setter;
    private boolean getter;

    protected ReflectMethod(ReflectClass reflectClass, Method method) {
        super(reflectClass, method);
        this.accessor = reflectClass.getAccessor();
        this.reflectedMethod = method;
        this.accessorIndex = this.accessor == null ? -1 : this.accessor.getMethodIndex(method);
        this.initialize();
    }

    @Override
    public String getName() {
        return this.reflectedMethod.getName();
    }

    public Method getReflectedMethod() {
        return this.reflectedMethod;
    }

    public ReflectParameter[] getParameters() {
        return this.parameters;
    }

    public Class<?> getReturnType() {
        return this.reflectedMethod.getReturnType();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.reflectedMethod.getModifiers());
    }

    public boolean isSynthetic() {
        return this.reflectedMethod.isSynthetic();
    }

    public boolean isGetterMethod() {
        return this.getter;
    }

    public boolean isSetterMethod() {
        return this.setter;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClsss) {
        return this.reflectedMethod.isAnnotationPresent(annotationClsss);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.reflectedMethod.getAnnotation(annotationClass);
    }

    public Annotation[] getAnnotations() {
        return this.reflectedMethod.getAnnotations();
    }

    public boolean hasReturnValue() {
        return !Classes.isVoid(this.reflectedMethod.getReturnType());
    }

    public Object invoke(Object instance, Object ... args) {
        try {
            if (this.parameters.length != args.length) {
                throw new IllegalArgumentException("argument's length must be " + this.parameters.length);
            }
            for (int i = 0; i < args.length; ++i) {
                if (null != args[i]) continue;
                args[i] = Classes.getDefaultValue(this.parameters[i].getType());
            }
            if (this.accessorIndex == -1) {
                if (!this.reflectedMethod.isAccessible()) {
                    this.reflectedMethod.setAccessible(true);
                }
                return this.reflectedMethod.invoke(instance, args);
            }
            return this.reflectClass.getAccessor().invokeMethod(instance, this.accessorIndex, args);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ReflectException(Strings.format("Error invoking method '{0}'", this.getName()), e);
        }
    }

    public Object invokeStatic(Object ... args) {
        try {
            if (this.parameters.length != args.length) {
                throw new IllegalArgumentException("argument's length must be " + this.parameters.length);
            }
            for (int i = 0; i < args.length; ++i) {
                if (null != args[i]) continue;
                args[i] = Classes.getDefaultValue(this.parameters[i].getType());
            }
            return this.reflectedMethod.invoke(null, args);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ReflectException(Strings.format("Error invoking method '{0}'", this.getName()), e);
        }
    }

    private void initialize() {
        this.parameters = new ReflectParameter[this.reflectedMethod.getParameterTypes().length];
        if (this.parameters.length > 0) {
            String[] names = Reflection.getParameterNames(this.reflectedMethod);
            if (null == names) {
                names = ReflectMethod.createUnknowParameterNames(this.parameters.length);
            }
            for (int i = 0; i < this.parameters.length; ++i) {
                Parameter p = this.reflectedMethod.getParameters()[i];
                this.parameters[i] = new ReflectParameter(i + 1, names[i], p, this.reflectedMethod.getGenericParameterTypes()[i]);
            }
        }
    }

    void setSetterOf(ReflectField field) {
        this.setter = true;
    }

    void setGetterOf(ReflectField field) {
        this.getter = true;
    }

    private static String[] createUnknowParameterNames(int length) {
        String[] names = new String[length];
        for (int i = 0; i < length; ++i) {
            names[i] = "arg" + (i + 1);
        }
        return names;
    }

    public String toString() {
        return this.reflectedMethod.toString();
    }
}

