/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import leap.lang.Named;
import leap.lang.TypeInfo;
import leap.lang.Types;
import leap.lang.reflect.ReflectValued;

public class ReflectParameter
implements Named,
ReflectValued {
    private final int index;
    private final String name;
    private final Parameter p;
    private final Type genericType;
    private final TypeInfo typeInfo;

    public ReflectParameter(int index, String name, Parameter p, Type genericType) {
        this.index = index;
        this.name = name;
        this.p = p;
        this.genericType = genericType;
        this.typeInfo = Types.getTypeInfo(p.getType(), genericType);
    }

    public Parameter getReflectedParameter() {
        return this.p;
    }

    public final int getIndex() {
        return this.index;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Class<?> getType() {
        return this.p.getType();
    }

    public final TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    @Override
    public final Type getGenericType() {
        return this.genericType;
    }

    @Override
    public final Annotation[] getAnnotations() {
        return this.p.getAnnotations();
    }

    @Override
    public final <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return this.p.getAnnotation(annotationType);
    }

    @Override
    public final boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }

    @Override
    public Object getValue(Object bean) {
        return ((Object[])bean)[this.index - 1];
    }

    @Override
    public void setValue(Object bean, Object value) {
        ((Object[])bean)[this.index - 1] = value;
    }
}

