/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import leap.lang.Args;
import leap.lang.Arrays2;
import leap.lang.Classes;
import leap.lang.Factory;
import leap.lang.Strings;
import leap.lang.exception.ObjectNotFoundException;
import leap.lang.exception.TooManyElementsException;
import leap.lang.reflect.ASMReflectFactory;
import leap.lang.reflect.ASMReflectMetadata;
import leap.lang.reflect.ReflectClass;
import leap.lang.reflect.ReflectException;
import leap.lang.reflect.ReflectFactory;
import leap.lang.reflect.ReflectMetadata;

public class Reflection {
    private static ReflectMetadata metadata = Factory.newInstance(ReflectMetadata.class, ASMReflectMetadata.class);
    private static ReflectFactory factory = Factory.newInstance(ReflectFactory.class, ASMReflectFactory.class);

    protected static ReflectMetadata metadata() {
        return metadata;
    }

    protected static ReflectFactory factory() {
        return factory;
    }

    public static <T> T newInstance(Class<T> clazz) {
        return ReflectClass.of(clazz).newInstance();
    }

    public static <T> T newInstance(Constructor<T> constructor) {
        return Reflection.newInstance(constructor, new Object[]{Arrays2.EMPTY_BOOLEAN_ARRAY});
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            Reflection.handleException(e);
            return null;
        }
    }

    public static String[] getParameterNames(Method method) {
        return metadata.getParameterNames(method);
    }

    public static String[] getParameterNames(Constructor<?> constructor) {
        return metadata.getParameterNames(constructor);
    }

    public static List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> search = clazz; search != null; search = search.getSuperclass()) {
            for (Field field : search.getDeclaredFields()) {
                fields.add(field);
            }
        }
        return fields;
    }

    public static String fullQualifyName(Method m) {
        StringBuilder sb = new StringBuilder(50);
        sb.append(m.getDeclaringClass().getName()).append(".").append(m.getName());
        sb.append("(");
        Class<?>[] paramTypes = m.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(paramTypes[i].getSimpleName());
        }
        sb.append(")");
        return sb.toString();
    }

    public static Method getMethod(Class<?> cls, String name) throws ObjectNotFoundException, TooManyElementsException {
        List<Method> methods = Reflection.getMethods(cls, name);
        if (methods.isEmpty()) {
            throw new ObjectNotFoundException("No such method '" + name + "' in class '" + cls.getName() + "'");
        }
        if (methods.size() > 1) {
            throw new TooManyElementsException("There are " + methods.size() + " methods named '" + name + "' in class '" + cls.getName() + "'");
        }
        return methods.get(0);
    }

    public static Method getMethodByFqName(String fqName) throws ObjectNotFoundException {
        int separateIndex;
        int leftParenIndex = fqName.lastIndexOf(40);
        int n = separateIndex = leftParenIndex != -1 ? fqName.lastIndexOf(46, leftParenIndex) : fqName.lastIndexOf(46);
        if (separateIndex > 0) {
            String className = fqName.substring(0, separateIndex);
            String methodName = fqName.substring(separateIndex + 1, separateIndex != -1 ? separateIndex : fqName.length());
            String[] paramTypes = null;
            if (separateIndex != -1) {
                paramTypes = Strings.split(fqName.substring(separateIndex + 1, fqName.length() + 1), ",");
            }
            Class<?> clazz = Classes.forName(className);
            List<Method> methods = Reflection.getMethods(clazz, methodName);
            for (Method method : methods) {
                if (null == paramTypes || paramTypes.length == 0) {
                    if (method.getParameterTypes().length != 0) continue;
                    return method;
                }
                if (method.getParameterTypes().length != paramTypes.length) continue;
                boolean matched = true;
                for (int i = 0; i < paramTypes.length; ++i) {
                    Class<?> typeClass = method.getParameterTypes()[i];
                    String typeName = paramTypes[i];
                    if (typeClass.getSimpleName().equals(typeName) || typeClass.getName().equals(typeName)) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue;
                return method;
            }
        }
        throw new ObjectNotFoundException("method '" + fqName + "' not found");
    }

    public static Method getMethodByNameOrDesc(Class<?> cls, String methodNameOrDesc) throws ObjectNotFoundException {
        int leftParenIndex = methodNameOrDesc.lastIndexOf(40);
        if (leftParenIndex < 0) {
            return Reflection.getMethod(cls, methodNameOrDesc);
        }
        int rightParenIndex = methodNameOrDesc.lastIndexOf(41);
        if (rightParenIndex != methodNameOrDesc.length() - 1) {
            throw new IllegalArgumentException("Invalid method desc '" + methodNameOrDesc + "'");
        }
        String methodName = methodNameOrDesc.substring(0, leftParenIndex);
        String paramsDesc = methodNameOrDesc.substring(leftParenIndex + 1, methodNameOrDesc.length() - 1);
        String[] paramTypes = Strings.split(paramsDesc, ",");
        List<Method> methods = Reflection.getMethods(cls, methodName);
        for (Method method : methods) {
            if (null == paramTypes || paramTypes.length == 0) {
                if (method.getParameterTypes().length != 0) continue;
                return method;
            }
            if (method.getParameterTypes().length != paramTypes.length) continue;
            boolean matched = true;
            for (int i = 0; i < paramTypes.length; ++i) {
                Class<?> typeClass = method.getParameterTypes()[i];
                String typeName = paramTypes[i];
                if (typeClass.getSimpleName().equals(typeName) || typeClass.getName().equals(typeName)) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return method;
        }
        throw new ObjectNotFoundException("Method '" + methodNameOrDesc + "' not found in class '" + cls.getName() + "'");
    }

    public static List<Method> getMethods(Class<?> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> search = clazz; search != null; search = search.getSuperclass()) {
            for (Method method : search.getDeclaredMethods()) {
                if (method.isSynthetic()) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    public static List<Method> getMethods(Class<?> clazz, String name) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> search = clazz; search != null; search = search.getSuperclass()) {
            for (Method method : search.getDeclaredMethods()) {
                if (!method.getName().equals(name)) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    public static void handleException(Exception ex) {
        if (ex instanceof InvocationTargetException) {
            Throwable cause = ((InvocationTargetException)ex).getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new ReflectException(ex);
        }
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof NoSuchFieldException) {
            throw new IllegalStateException("Field not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Illegal access method or field: " + ex.getMessage());
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new ReflectException(ex);
    }

    public static Method findMethod(Class<?> clazz, String name) {
        return Reflection.findMethod(clazz, name, Arrays2.EMPTY_CLASS_ARRAY);
    }

    public static Method findFirstDeclaredMethod(Class<?> cls, String name) {
        for (Method m : cls.getDeclaredMethods()) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        Args.notNull(clazz, "clazz");
        Args.notNull(name, "method name");
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods()) {
                if (!name.equals(method.getName()) || paramTypes != null && !Arrays2.equals(paramTypes, method.getParameterTypes())) continue;
                return method;
            }
        }
        return null;
    }

    public static Method findMethod(Class<?> clazz, String name, String ... paramTypeNames) {
        Args.notNull(clazz, "clazz");
        Args.notNull(name, "method name");
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods()) {
                if (!name.equals(method.getName())) continue;
                if (null == paramTypeNames || paramTypeNames.length == 0) {
                    if (method.getParameterTypes().length != 0) continue;
                    return method;
                }
                if (method.getParameterTypes().length != paramTypeNames.length) continue;
                boolean matched = true;
                for (int i = 0; i < paramTypeNames.length; ++i) {
                    Class<?> typeClass = method.getParameterTypes()[i];
                    String typeName = paramTypeNames[i];
                    if (typeClass.getSimpleName().equals(typeName) || typeClass.getName().equals(typeName)) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue;
                return method;
            }
        }
        return null;
    }

    public static Field findField(Class<?> clazz, String name) {
        return Reflection.findField(clazz, name, null);
    }

    public static Field findField(Class<?> clazz, String name, Class<?> type) {
        Args.notNull(clazz, "clazz");
        Args.assertTrue(name != null || type != null, "Either name or type of the field must be specified");
        for (Class<?> searchType = clazz; !Object.class.equals(searchType) && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = searchType.getDeclaredFields()) {
                if (name != null && !name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return field;
            }
        }
        return null;
    }

    public static Object invokeMethod(Method method, Object target) {
        return Reflection.invokeMethod(method, target, Arrays2.EMPTY_OBJECT_ARRAY);
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            Reflection.handleException(ex);
            throw new ReflectException(ex.getMessage(), ex);
        }
    }

    public static Object getFieldValue(Object target, Field field) {
        try {
            return field.get(target);
        }
        catch (IllegalAccessException ex) {
            Reflection.handleException(ex);
            throw new ReflectException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    protected Reflection() {
    }
}

