/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import leap.lang.Exceptions;
import leap.lang.exception.NestedIOException;
import leap.lang.io.Files;
import leap.lang.net.Urls;
import leap.lang.resource.AbstractResource;
import leap.lang.resource.Resource;
import leap.lang.resource.VfsResource;
import leap.lang.resource.VfsUtils;

public abstract class AbstractFileResolvingResource
extends AbstractResource {
    @Override
    public File getFile() throws NestedIOException {
        try {
            URL url = this.getURL();
            if (url.getProtocol().startsWith("vfs")) {
                return VfsResourceDelegate.getResource(url).getFile();
            }
            return Files.fromUrl(url, this.getDescription());
        }
        catch (IOException e) {
            throw Exceptions.wrap(e);
        }
    }

    @Override
    protected File getFileForLastModifiedCheck() throws IOException {
        URL url = this.getURL();
        if (Urls.isJarUrl(url)) {
            URL actualUrl = Urls.getJarFileURL(url);
            if (actualUrl.getProtocol().startsWith("vfs")) {
                return VfsResourceDelegate.getResource(actualUrl).getFile();
            }
            return Files.fromUrl(actualUrl, "Jar URL");
        }
        return this.getFile();
    }

    protected File getFile(URI uri) throws IOException {
        if (uri.getScheme().startsWith("vfs")) {
            return VfsResourceDelegate.getResource(uri).getFile();
        }
        return Files.fromUri(uri, this.getDescription());
    }

    @Override
    public boolean exists() {
        try {
            HttpURLConnection httpCon;
            URL url = this.getURL();
            if (Urls.isFileUrl(url)) {
                return this.getFile().exists();
            }
            URLConnection con = url.openConnection();
            Urls.setUseCachesIfNecessary(con);
            HttpURLConnection httpURLConnection = httpCon = con instanceof HttpURLConnection ? (HttpURLConnection)con : null;
            if (httpCon != null) {
                httpCon.setRequestMethod("HEAD");
                int code = httpCon.getResponseCode();
                if (code == 200) {
                    return true;
                }
                if (code == 404) {
                    return false;
                }
            }
            if (con.getContentLength() >= 0) {
                return true;
            }
            if (httpCon != null) {
                httpCon.disconnect();
                return false;
            }
            InputStream is = this.getInputStream();
            is.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public boolean isReadable() {
        try {
            URL url = this.getURL();
            if (Urls.isFileUrl(url)) {
                File file = this.getFile();
                return file.canRead() && !file.isDirectory();
            }
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public long contentLength() throws IOException {
        URL url = this.getURL();
        if (Urls.isFileUrl(url)) {
            return this.getFile().length();
        }
        URLConnection con = url.openConnection();
        Urls.setUseCachesIfNecessary(con);
        if (con instanceof HttpURLConnection) {
            ((HttpURLConnection)con).setRequestMethod("HEAD");
        }
        return con.getContentLength();
    }

    @Override
    public long lastModified() throws IOException {
        URL url = this.getURL();
        if (Urls.isFileUrl(url) || Urls.isJarUrl(url)) {
            return super.lastModified();
        }
        URLConnection con = url.openConnection();
        Urls.setUseCachesIfNecessary(con);
        if (con instanceof HttpURLConnection) {
            ((HttpURLConnection)con).setRequestMethod("HEAD");
        }
        return con.getLastModified();
    }

    private static class VfsResourceDelegate {
        private VfsResourceDelegate() {
        }

        public static Resource getResource(URL url) throws IOException {
            return new VfsResource(VfsUtils.getRoot(url));
        }

        public static Resource getResource(URI uri) throws IOException {
            return new VfsResource(VfsUtils.getRoot(uri));
        }
    }
}

