/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import leap.lang.Charsets;
import leap.lang.Exceptions;
import leap.lang.exception.NestedIOException;
import leap.lang.io.IO;
import leap.lang.net.Urls;
import leap.lang.resource.FileResource;
import leap.lang.resource.Resource;
import leap.lang.resource.SimpleFileResource;

public abstract class AbstractResource
implements Resource {
    @Override
    public InputStreamReader getInputStreamReader() throws NestedIOException {
        return this.getInputStreamReader(Charsets.defaultCharset());
    }

    @Override
    public InputStreamReader getInputStreamReader(Charset charset) {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(this.getInputStream(), Charsets.get(charset));
        }
        catch (IOException e) {
            IO.close(reader);
            throw Exceptions.wrap(e);
        }
        return reader;
    }

    @Override
    public String getContent() throws NestedIOException {
        InputStreamReader r = null;
        try {
            r = this.getInputStreamReader();
            String string = IO.readString(r);
            return string;
        }
        finally {
            IO.close(r);
        }
    }

    @Override
    public boolean exists() {
        try {
            return this.getFile().exists();
        }
        catch (Exception ex) {
            try {
                InputStream is = this.getInputStream();
                is.close();
                return true;
            }
            catch (Throwable isEx) {
                return false;
            }
        }
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public boolean isFile() {
        try {
            File file = this.getFile();
            return null != file;
        }
        catch (IllegalStateException | NestedIOException e) {
            return false;
        }
    }

    @Override
    public URL getURL() throws IOException {
        throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL");
    }

    @Override
    public String getURLString() throws IllegalStateException {
        try {
            return this.getURL().toExternalForm();
        }
        catch (IOException e) {
            throw new IllegalStateException("Error calling getURL()", e);
        }
    }

    @Override
    public URI getURI() throws IOException {
        URL url = this.getURL();
        try {
            return Urls.toURI(url);
        }
        catch (URISyntaxException ex) {
            throw new IOException("Invalid URI [" + url + "]", ex);
        }
    }

    @Override
    public File getFile() {
        throw new IllegalStateException(this.getDescription() + " cannot be resolved to absolute file path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long contentLength() throws IOException {
        InputStream is = this.getInputStream();
        try {
            int read;
            long size = 0L;
            byte[] buf = new byte[255];
            while ((read = is.read(buf)) != -1) {
                size += (long)read;
            }
            long l = size;
            return l;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public long lastModified() throws IOException {
        long lastModified = this.getFileForLastModifiedCheck().lastModified();
        if (lastModified == 0L) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved in the file system for resolving its last-modified timestamp");
        }
        return lastModified;
    }

    protected File getFileForLastModifiedCheck() throws IOException {
        return this.getFile();
    }

    @Override
    public Resource createRelative(String relativePath) throws IOException {
        throw new FileNotFoundException("Cannot create a relative resource for " + this.getDescription());
    }

    @Override
    public FileResource toFileResource() {
        if (!this.isFile()) {
            throw new IllegalStateException("Cannot convert non 'file' to to FileResource");
        }
        if (this instanceof FileResource) {
            return (FileResource)((Object)this);
        }
        try {
            return new SimpleFileResource(this.getFile());
        }
        catch (IllegalStateException | NestedIOException e) {
            throw new IllegalStateException("Cannot convert to FileResource, " + e.getMessage(), e);
        }
    }

    @Override
    public String getFilename() throws IllegalStateException {
        return null;
    }

    @Override
    public String getFilepath() {
        return this.getFile().getAbsolutePath();
    }

    @Override
    public String getClasspath() {
        return null;
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Resource && ((Resource)obj).getDescription().equals(this.getDescription());
    }

    public int hashCode() {
        return this.getDescription().hashCode();
    }
}

