/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.resource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import leap.lang.Args;
import leap.lang.Classes;
import leap.lang.path.Paths;
import leap.lang.resource.AbstractFileResolvingResource;
import leap.lang.resource.Resource;

public class ClassPathResource
extends AbstractFileResolvingResource {
    private final String path;
    private ClassLoader classLoader;
    private Class<?> clazz;

    public ClassPathResource(String path) {
        this(path, (ClassLoader)null);
    }

    public ClassPathResource(String path, ClassLoader classLoader) {
        Args.notNull(path, "path");
        String pathToUse = Paths.normalize(path);
        if (pathToUse.startsWith("/")) {
            pathToUse = pathToUse.substring(1);
        }
        this.path = pathToUse;
        this.classLoader = classLoader != null ? classLoader : Classes.getClassLoader();
    }

    public ClassPathResource(String path, Class<?> clazz) {
        Args.notNull(path, "path");
        this.path = Paths.normalize(path);
        this.clazz = clazz;
    }

    protected ClassPathResource(String path, ClassLoader classLoader, Class<?> clazz) {
        this.path = Paths.normalize(path);
        this.classLoader = classLoader;
        this.clazz = clazz;
    }

    public final String getPath() {
        return this.path;
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader != null ? this.classLoader : this.clazz.getClassLoader();
    }

    @Override
    public boolean exists() {
        URL url = this.clazz != null ? this.clazz.getResource(this.path) : this.classLoader.getResource(this.path);
        return url != null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is = this.clazz != null ? this.clazz.getResourceAsStream(this.path) : this.classLoader.getResourceAsStream(this.path);
        if (is == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be opened because it does not exist");
        }
        return is;
    }

    @Override
    public URL getURL() throws IOException {
        URL url = this.clazz != null ? this.clazz.getResource(this.path) : this.classLoader.getResource(this.path);
        if (url == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL because it does not exist");
        }
        return url;
    }

    @Override
    public Resource createRelative(String relativePath) {
        String pathToUse = Paths.applyRelative(this.path, relativePath);
        return new ClassPathResource(pathToUse, this.classLoader, this.clazz);
    }

    @Override
    public String getFilename() {
        return Paths.getFileName(this.path);
    }

    @Override
    public String getDescription() {
        StringBuilder builder = new StringBuilder("class path resource [");
        if (this.clazz != null) {
            builder.append(Classes.getPackageResourcePath(this.clazz));
            builder.append('/');
        }
        builder.append(this.path);
        builder.append(']');
        return builder.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ClassPathResource) {
            ClassPathResource otherRes = (ClassPathResource)obj;
            return this.path.equals(otherRes.path) && Objects.equals(this.classLoader, otherRes.classLoader) && Objects.equals(this.clazz, otherRes.clazz);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public String getClasspath() {
        return this.path;
    }

    @Override
    public String toString() {
        return "classpath:" + this.path;
    }
}

