/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.resource;

import leap.lang.Args;
import leap.lang.path.Paths;
import leap.lang.resource.ClassPathResource;
import leap.lang.resource.ContextResource;
import leap.lang.resource.DefaultResourceLoader;
import leap.lang.resource.Resource;

class ClassRelativeResourceLoader
extends DefaultResourceLoader {
    private final Class clazz;

    public ClassRelativeResourceLoader(Class clazz) {
        Args.notNull(clazz, "clazz");
        this.clazz = clazz;
        this.setClassLoader(clazz.getClassLoader());
    }

    @Override
    protected Resource getResourceByPath(String path) {
        return new ClassRelativeContextResource(path, this.clazz);
    }

    private static class ClassRelativeContextResource
    extends ClassPathResource
    implements ContextResource {
        private final Class clazz;

        public ClassRelativeContextResource(String path, Class clazz) {
            super(path, clazz);
            this.clazz = clazz;
        }

        @Override
        public String getPathWithinContext() {
            return this.getPath();
        }

        @Override
        public Resource createRelative(String relativePath) {
            String pathToUse = Paths.applyRelative(this.getPath(), relativePath);
            return new ClassRelativeContextResource(pathToUse, this.clazz);
        }
    }
}

