/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.resource;

import java.net.MalformedURLException;
import java.net.URL;
import leap.lang.Args;
import leap.lang.Classes;
import leap.lang.path.Paths;
import leap.lang.resource.ClassPathResource;
import leap.lang.resource.ContextResource;
import leap.lang.resource.Resource;
import leap.lang.resource.ResourceLoader;
import leap.lang.resource.UrlResource;

public class DefaultResourceLoader
implements ResourceLoader {
    private ClassLoader classLoader;

    public DefaultResourceLoader() {
    }

    public DefaultResourceLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader != null ? this.classLoader : Classes.getClassLoader();
    }

    @Override
    public Resource getResource(String name) {
        Args.notNull(name, "name");
        if (name.startsWith("classpath:")) {
            return new ClassPathResource(name.substring("classpath:".length()), this.getClassLoader());
        }
        try {
            URL url = new URL(name);
            return new UrlResource(url);
        }
        catch (MalformedURLException ex) {
            return this.getResourceByPath(name);
        }
    }

    protected Resource getResourceByPath(String path) {
        return new ClassPathContextResource(path, this.getClassLoader());
    }

    private static class ClassPathContextResource
    extends ClassPathResource
    implements ContextResource {
        public ClassPathContextResource(String path, ClassLoader classLoader) {
            super(path, classLoader);
        }

        @Override
        public String getPathWithinContext() {
            return this.getPath();
        }

        @Override
        public Resource createRelative(String relativePath) {
            String pathToUse = Paths.applyRelative(this.getPath(), relativePath);
            return new ClassPathContextResource(pathToUse, this.getClassLoader());
        }
    }
}

