/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.resource;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import leap.lang.Args;
import leap.lang.New;
import leap.lang.Strings;
import leap.lang.exception.NestedIOException;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.lang.net.NET;
import leap.lang.net.Urls;
import leap.lang.path.PathMatcher;
import leap.lang.path.Paths;
import leap.lang.reflect.Reflection;
import leap.lang.resource.DefaultResourceLoader;
import leap.lang.resource.Resource;
import leap.lang.resource.ResourceLoader;
import leap.lang.resource.ResourceScanner;
import leap.lang.resource.Resources;
import leap.lang.resource.SimpleFileResource;
import leap.lang.resource.UrlResource;
import leap.lang.resource.VfsResource;
import leap.lang.resource.VfsUtils;

class DefaultResourceScanner
implements ResourceScanner {
    private static final Log logger = LogFactory.get(DefaultResourceScanner.class);
    private static Method equinoxResolveMethod;
    private final ResourceLoader resourceLoader;
    private boolean quietly = true;
    private PathMatcher pathMatcher = Resources.matcher;
    private ExecutorService executorService;

    public DefaultResourceScanner() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public DefaultResourceScanner(ClassLoader classLoader) {
        this.resourceLoader = new DefaultResourceLoader(classLoader);
    }

    public DefaultResourceScanner(ResourceLoader resourceLoader) {
        Args.notNull(resourceLoader, "ResourceLoader");
        this.resourceLoader = resourceLoader;
    }

    public boolean isQuietly() {
        return this.quietly;
    }

    public void setQuietly(boolean quietly) {
        this.quietly = quietly;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getResourceLoader().getClassLoader();
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Args.notNull(pathMatcher, "PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public Resource getResource(String location) {
        return this.getResourceLoader().getResource(location);
    }

    @Override
    public String extractRootDirPath(String location) {
        int prefixEnd = location.indexOf(":") + 1;
        int rootDirEnd = location.length();
        while (rootDirEnd > prefixEnd && this.getPathMatcher().isPattern(location.substring(prefixEnd, rootDirEnd))) {
            rootDirEnd = location.lastIndexOf(47, rootDirEnd - 2) + 1;
        }
        if (rootDirEnd == 0) {
            rootDirEnd = prefixEnd;
        }
        return location.substring(0, rootDirEnd);
    }

    @Override
    public Resource[] scan(String locationPattern) throws IOException {
        Args.notNull(locationPattern, "Location pattern");
        if (locationPattern.startsWith("classpath*:")) {
            String locationPatternWithPrefix = locationPattern.substring("classpath*:".length());
            if (this.getPathMatcher().isPattern(locationPatternWithPrefix)) {
                return this.findPathMatchingResources(locationPattern);
            }
            return this.findAllClassPathResources(locationPatternWithPrefix);
        }
        int prefixEnd = locationPattern.indexOf(":") + 1;
        if (this.getPathMatcher().isPattern(locationPattern.substring(prefixEnd))) {
            return this.findPathMatchingResources(locationPattern);
        }
        return new Resource[]{this.getResourceLoader().getResource(locationPattern)};
    }

    protected Resource[] findAllClassPathResources(String location) throws IOException {
        String path = location;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        Enumeration<URL> resourceUrls = this.getClassLoader().getResources(path);
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(16);
        while (resourceUrls.hasMoreElements()) {
            URL url = resourceUrls.nextElement();
            result.add(this.convertClassLoaderURL(url, location));
        }
        return result.toArray(new Resource[result.size()]);
    }

    protected Resource convertClassLoaderURL(URL url, String classPathPrefix) {
        return new UrlResource(url, classPathPrefix);
    }

    protected String getResourceLocation(Resource resource) throws IOException {
        if (!Strings.isEmpty(resource.getClasspath())) {
            return "classpath:" + resource.getClasspath();
        }
        return "file:" + resource.getFile().getAbsolutePath();
    }

    @Override
    public Resource[] scan(Resource rootDirResource, String subPattern) throws IOException {
        String rootDirPath = this.getResourceLocation(rootDirResource);
        return this.findPathMatchingResources(rootDirPath, subPattern, new Resource[]{rootDirResource});
    }

    protected Resource[] findPathMatchingResources(String locationPattern) throws IOException {
        String rootDirPath = this.extractRootDirPath(locationPattern);
        String subPattern = locationPattern.substring(rootDirPath.length());
        return this.findPathMatchingResources(rootDirPath, subPattern, this.scan(rootDirPath));
    }

    protected Resource[] findPathMatchingResources(final String rootDirPath, final String subPattern, Resource[] rootDirResources) throws IOException {
        final AbstractSet result = null == this.executorService ? new LinkedHashSet() : new CopyOnWriteArraySet();
        ArrayList<Future<?>> futures = New.arrayList();
        for (Resource rootDirResource : rootDirResources) {
            if (this.isQuietly() && !rootDirResource.exists()) continue;
            final Resource rootResourceToScan = rootDirResource = this.resolveRootDirResource(rootDirResource);
            if (null != this.executorService) {
                futures.add(this.executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DefaultResourceScanner.this.scan(result, rootResourceToScan, rootDirPath, subPattern);
                        }
                        catch (IOException e) {
                            throw new NestedIOException(e);
                        }
                    }
                }));
                continue;
            }
            this.scan(result, rootDirResource, rootDirPath, subPattern);
        }
        if (null != this.executorService) {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Resolved location pattern [" + subPattern + "] to resources " + result);
        }
        return result.toArray(new Resource[result.size()]);
    }

    protected void scan(Set<Resource> result, Resource rootDirResource, String rootDirPath, String subPattern) throws IOException {
        if (this.isJarResource(rootDirResource)) {
            result.addAll(this.doFindPathMatchingJarResources(rootDirResource, subPattern));
        } else if (rootDirResource.getURL().getProtocol().startsWith("vfs")) {
            result.addAll(VfsResourceMatchingDelegate.findMatchingResources(rootDirResource, subPattern, this.getPathMatcher()));
        } else {
            result.addAll(this.doFindPathMatchingFileResources(rootDirResource, rootDirPath, subPattern));
        }
    }

    protected Resource resolveRootDirResource(Resource original) throws IOException {
        URL url;
        if (equinoxResolveMethod != null && (url = original.getURL()).getProtocol().startsWith("bundle")) {
            return new UrlResource((URL)Reflection.invokeMethod(equinoxResolveMethod, null, url));
        }
        return original;
    }

    protected boolean isJarResource(Resource resource) throws IOException {
        return Urls.isJarUrl(resource.getURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Resource> doFindPathMatchingJarResources(Resource rootDirResource, String subPattern) throws IOException {
        String rootEntryPath;
        String jarFileUrl;
        JarFile jarFile;
        URLConnection con = rootDirResource.getURL().openConnection();
        boolean newJarFile = false;
        if (con instanceof JarURLConnection) {
            JarURLConnection jarCon = (JarURLConnection)con;
            NET.useCachesIfNecessary(jarCon);
            jarFile = jarCon.getJarFile();
            jarFileUrl = jarCon.getJarFileURL().toExternalForm();
            JarEntry jarEntry = jarCon.getJarEntry();
            rootEntryPath = jarEntry != null ? jarEntry.getName() : "";
        } else {
            String urlFile = rootDirResource.getURL().getFile();
            int separatorIndex = urlFile.indexOf("!/");
            if (separatorIndex != -1) {
                jarFileUrl = urlFile.substring(0, separatorIndex);
                rootEntryPath = urlFile.substring(separatorIndex + "!/".length());
                jarFile = this.getJarFile(jarFileUrl);
            } else {
                jarFile = new JarFile(urlFile);
                jarFileUrl = urlFile;
                rootEntryPath = "";
            }
            newJarFile = true;
        }
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("Looking for matching resources in jar file [" + jarFileUrl + "]");
            }
            if (!"".equals(rootEntryPath) && !rootEntryPath.endsWith("/")) {
                rootEntryPath = rootEntryPath + "/";
            }
            LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(8);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryPath = entry.getName();
                if (!entryPath.startsWith(rootEntryPath)) continue;
                String relativePath = entryPath.substring(rootEntryPath.length());
                if (!this.getPathMatcher().match(subPattern, relativePath)) continue;
                result.add(rootDirResource.createRelative(relativePath));
            }
            LinkedHashSet<Resource> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            if (newJarFile) {
                jarFile.close();
            }
        }
    }

    protected JarFile getJarFile(String jarFileUrl) throws IOException {
        if (jarFileUrl.startsWith("file:")) {
            try {
                return new JarFile(Urls.toURI(jarFileUrl).getSchemeSpecificPart());
            }
            catch (URISyntaxException ex) {
                return new JarFile(jarFileUrl.substring("file:".length()));
            }
        }
        return new JarFile(jarFileUrl);
    }

    protected Set<Resource> doFindPathMatchingFileResources(Resource rootDirResource, String rootDirPath, String subPattern) throws IOException {
        File rootDir;
        try {
            rootDir = rootDirResource.getFile().getAbsoluteFile();
        }
        catch (IllegalStateException | NestedIOException ex) {
            if (logger.isWarnEnabled()) {
                logger.warn("Cannot search for matching files underneath " + rootDirResource + " because it does not correspond to a directory in the file system", ex);
            }
            return Collections.emptySet();
        }
        return this.doFindMatchingFileSystemResources(rootDir, rootDirPath, subPattern);
    }

    protected Set<Resource> doFindMatchingFileSystemResources(File rootDir, String rootDirPath, String subPattern) throws IOException {
        String classpathRoot;
        if (logger.isTraceEnabled()) {
            logger.trace("Looking for matching resources in directory tree [" + rootDir.getPath() + "]");
        }
        Set<File> matchingFiles = this.retrieveMatchingFiles(rootDir, subPattern);
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(matchingFiles.size());
        boolean isClasspath = rootDirPath.startsWith("classpath*:") || rootDirPath.startsWith("classpath:");
        int rootDirPathLength = rootDir.getAbsolutePath().length();
        String string = classpathRoot = isClasspath ? rootDirPath.substring(rootDirPath.indexOf(":") + 1) : null;
        if (null != classpathRoot && classpathRoot.startsWith("/")) {
            classpathRoot = classpathRoot.substring(1);
        }
        for (File file : matchingFiles) {
            if (isClasspath) {
                String classpath = classpathRoot + Paths.normalize(file.getAbsolutePath().substring(rootDirPathLength + 1));
                result.add(new SimpleFileResource(file, classpath));
                continue;
            }
            result.add(new SimpleFileResource(file));
        }
        return result;
    }

    protected Set<File> retrieveMatchingFiles(File rootDir, String pattern) throws IOException {
        if (!rootDir.exists()) {
            if (logger.isTraceEnabled()) {
                logger.trace("Skipping [" + rootDir.getAbsolutePath() + "] because it does not exist");
            }
            return Collections.emptySet();
        }
        if (!rootDir.isDirectory()) {
            if (logger.isWarnEnabled()) {
                logger.warn("Skipping [" + rootDir.getAbsolutePath() + "] because it does not denote a directory");
            }
            return Collections.emptySet();
        }
        if (!rootDir.canRead()) {
            if (logger.isWarnEnabled()) {
                logger.warn("Cannot search for matching files underneath directory [" + rootDir.getAbsolutePath() + "] because the application is not allowed to read the directory");
            }
            return Collections.emptySet();
        }
        String fullPattern = Strings.replace(rootDir.getAbsolutePath(), File.separator, "/");
        if (!pattern.startsWith("/")) {
            fullPattern = fullPattern + "/";
        }
        fullPattern = fullPattern + Strings.replace(pattern, File.separator, "/");
        LinkedHashSet<File> result = new LinkedHashSet<File>(8);
        this.doRetrieveMatchingFiles(fullPattern, rootDir, result);
        return result;
    }

    protected void doRetrieveMatchingFiles(String fullPattern, File dir, Set<File> result) throws IOException {
        File[] dirContents;
        if (logger.isTraceEnabled()) {
            logger.trace("Searching directory [" + dir.getAbsolutePath() + "] for files matching pattern [" + fullPattern + "]");
        }
        if ((dirContents = dir.listFiles()) == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Could not retrieve contents of directory [" + dir.getAbsolutePath() + "]");
            }
            return;
        }
        for (File content : dirContents) {
            String currPath = Strings.replace(content.getAbsolutePath(), File.separator, "/");
            if (content.isDirectory() && this.getPathMatcher().matchStart(fullPattern, currPath + "/")) {
                if (!content.canRead()) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Skipping subdirectory [" + dir.getAbsolutePath() + "] because the application is not allowed to read the directory");
                    }
                } else {
                    this.doRetrieveMatchingFiles(fullPattern, content, result);
                }
            }
            if (!this.getPathMatcher().match(fullPattern, currPath)) continue;
            result.add(content);
        }
    }

    static {
        try {
            Class<?> fileLocatorClass = DefaultResourceScanner.class.getClassLoader().loadClass("org.eclipse.core.runtime.FileLocator");
            equinoxResolveMethod = fileLocatorClass.getMethod("resolve", URL.class);
            logger.debug("Found Equinox FileLocator for OSGi bundle URL resolution");
        }
        catch (Throwable ex) {
            equinoxResolveMethod = null;
        }
    }

    private static class PatternVirtualFileVisitor
    implements InvocationHandler {
        private final String subPattern;
        private final PathMatcher pathMatcher;
        private final String rootPath;
        private final Set<Resource> resources = new LinkedHashSet<Resource>();

        public PatternVirtualFileVisitor(String rootPath, String subPattern, PathMatcher pathMatcher) {
            this.subPattern = subPattern;
            this.pathMatcher = pathMatcher;
            this.rootPath = rootPath.length() == 0 || rootPath.endsWith("/") ? rootPath : rootPath + "/";
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (Object.class.equals(method.getDeclaringClass())) {
                if (methodName.equals("equals")) {
                    return proxy == args[0];
                }
                if (methodName.equals("hashCode")) {
                    return System.identityHashCode(proxy);
                }
            } else {
                if ("getAttributes".equals(methodName)) {
                    return this.getAttributes();
                }
                if ("visit".equals(methodName)) {
                    this.visit(args[0]);
                    return null;
                }
                if ("toString".equals(methodName)) {
                    return this.toString();
                }
            }
            throw new IllegalStateException("Unexpected method invocation: " + method);
        }

        public void visit(Object vfsResource) {
            String relativePath = VfsUtils.getPath(vfsResource).substring(this.rootPath.length());
            if (this.pathMatcher.match(this.subPattern, relativePath)) {
                this.resources.add(new VfsResource(vfsResource));
            }
        }

        public Object getAttributes() {
            return VfsUtils.getVisitorAttribute();
        }

        public Set<Resource> getResources() {
            return this.resources;
        }

        public int size() {
            return this.resources.size();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("sub-pattern: ").append(this.subPattern);
            sb.append(", resources: ").append(this.resources);
            return sb.toString();
        }
    }

    private static class VfsResourceMatchingDelegate {
        private VfsResourceMatchingDelegate() {
        }

        public static Set<Resource> findMatchingResources(Resource rootResource, String locationPattern, PathMatcher pathMatcher) throws IOException {
            Object root = VfsUtils.findRoot(rootResource.getURL());
            PatternVirtualFileVisitor visitor = new PatternVirtualFileVisitor(VfsUtils.getPath(root), locationPattern, pathMatcher);
            VfsUtils.visit(root, visitor);
            return visitor.getResources();
        }
    }
}

