/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.resource;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import leap.lang.Args;
import leap.lang.resource.Resource;

class EncodedResource {
    private final Resource resource;
    private final String encoding;

    public EncodedResource(Resource resource) {
        this(resource, null);
    }

    public EncodedResource(Resource resource, String encoding) {
        Args.notNull(resource, "resource");
        this.resource = resource;
        this.encoding = encoding;
    }

    public final Resource getResource() {
        return this.resource;
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public Reader getReader() throws IOException {
        if (this.encoding != null) {
            return new InputStreamReader(this.resource.getInputStream(), this.encoding);
        }
        return new InputStreamReader(this.resource.getInputStream());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof EncodedResource) {
            EncodedResource otherRes = (EncodedResource)obj;
            return this.resource.equals(otherRes.resource) && Objects.equals(this.encoding, otherRes.encoding);
        }
        return false;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public String toString() {
        return this.resource.toString();
    }
}

