/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.resource;

import java.io.IOException;
import java.io.InputStream;
import leap.lang.resource.AbstractResource;

public class InputStreamResource
extends AbstractResource {
    private final InputStream inputStream;
    private final String description;
    private boolean read = false;

    public InputStreamResource(InputStream inputStream) {
        this(inputStream, "resource loaded through InputStream");
    }

    public InputStreamResource(InputStream inputStream, String description) {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream must not be null");
        }
        this.inputStream = inputStream;
        this.description = description != null ? description : "";
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public String getFilepath() {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException, IllegalStateException {
        if (this.read) {
            throw new IllegalStateException("InputStream has already been read - do not use InputStreamResource if a stream needs to be read multiple times");
        }
        this.read = true;
        return this.inputStream;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof InputStreamResource && ((InputStreamResource)obj).inputStream.equals(this.inputStream);
    }

    @Override
    public int hashCode() {
        return this.inputStream.hashCode();
    }
}

