/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import leap.lang.exception.NestedIOException;
import leap.lang.io.InputStreamSource;
import leap.lang.resource.FileResource;

public interface Resource
extends InputStreamSource {
    public InputStreamReader getInputStreamReader() throws NestedIOException;

    public InputStreamReader getInputStreamReader(Charset var1) throws NestedIOException;

    public String getContent() throws NestedIOException;

    public boolean exists();

    public boolean isReadable();

    public boolean isOpen();

    public boolean isFile();

    default public boolean isDirectory() {
        return this.isFile() && this.getFile().isDirectory();
    }

    public URL getURL() throws IOException;

    public String getURLString() throws IllegalStateException;

    public URI getURI() throws IOException;

    public File getFile() throws NestedIOException, IllegalStateException;

    public long contentLength() throws IOException;

    public long lastModified() throws IOException;

    public Resource createRelative(String var1) throws IOException;

    public FileResource toFileResource() throws IllegalStateException;

    public String getFilename();

    public String getFilepath() throws IllegalStateException;

    default public boolean hasClasspath() {
        return null != this.getClasspath();
    }

    public String getClasspath();

    public String getDescription();
}

