/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.resource;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import leap.lang.Args;
import leap.lang.Classes;
import leap.lang.Collections2;
import leap.lang.Exceptions;
import leap.lang.New;
import leap.lang.exception.NestedIOException;
import leap.lang.path.AntPathMatcher;
import leap.lang.path.PathMatcher;
import leap.lang.resource.DefaultResourceLoader;
import leap.lang.resource.DefaultResourceScanner;
import leap.lang.resource.FileResource;
import leap.lang.resource.Resource;
import leap.lang.resource.ResourceLoader;
import leap.lang.resource.ResourceScanner;
import leap.lang.resource.ResourceSet;
import leap.lang.resource.SimpleFileResource;
import leap.lang.resource.SimpleResourceSet;

public class Resources {
    static final PathMatcher matcher = new AntPathMatcher();
    static ResourceLoader loader = new DefaultResourceLoader();
    static ResourceScanner scanner = new DefaultResourceScanner(loader);
    private static final FileResource userDir = Resources.createFileResource(System.getProperty("user.dir"));

    public static PathMatcher getPathMatcher() {
        return matcher;
    }

    public static void setClassLoader(ClassLoader classLoader) {
        Args.notNull(classLoader, "classLoader");
        loader = new DefaultResourceLoader(classLoader);
        scanner = new DefaultResourceScanner(loader);
    }

    public static String getContent(String resource) {
        Resource r = Resources.getResource(resource);
        if (null == r || !r.exists()) {
            return null;
        }
        return r.getContent();
    }

    public static FileResource getUserDir() {
        return userDir;
    }

    public static Resource getResource(String name) {
        return loader.getResource(name);
    }

    public static FileResource createFileResource(File file) {
        Args.notNull(file, "file");
        return new SimpleFileResource(file);
    }

    public static FileResource createFileResource(String path) {
        Args.notEmpty(path, "path");
        return new SimpleFileResource(new File(path));
    }

    public static Resource getResource(Class<?> cls) {
        return Resources.getResource(cls, Classes.getClassFileName(cls));
    }

    public static Resource getResource(Class<?> clazz, String resourceNameInPackage) throws NestedIOException {
        Args.notNull(clazz, "clazz");
        Args.notNull(resourceNameInPackage, "resource name must not be null");
        String resourceLocation = "classpath:" + Classes.getPackageResourcePath(clazz) + "/" + resourceNameInPackage;
        return loader.getResource(resourceLocation);
    }

    public static Resource getResource(Resource current, String path) throws NestedIOException {
        Args.notNull(current, "current resource");
        Args.notNull(path, "resource path");
        try {
            if (path.indexOf(58) > 0 || path.startsWith("/")) {
                return Resources.getResource(path);
            }
            return current.createRelative(path);
        }
        catch (IOException e) {
            throw new NestedIOException(e);
        }
    }

    public static ResourceSet scan(String locationPattern) throws NestedIOException {
        try {
            return new SimpleResourceSet(scanner.scan(locationPattern));
        }
        catch (IOException e) {
            throw new NestedIOException(e);
        }
    }

    public static ResourceSet scanPackage(String basePackage) {
        String location = "classpath*:" + basePackage.replace('.', '/') + "/**/*";
        return Resources.scan(location);
    }

    public static ResourceSet scan(String ... locationPatterns) throws NestedIOException {
        if (null == locationPatterns || locationPatterns.length == 0) {
            return new SimpleResourceSet(new Resource[0]);
        }
        if (locationPatterns.length > 1) {
            ExecutorService executorService = Executors.newFixedThreadPool(locationPatterns.length);
            final CopyOnWriteArrayList result = new CopyOnWriteArrayList();
            ArrayList<Future<?>> futures = New.arrayList();
            for (int i = 0; i < locationPatterns.length; ++i) {
                final String string = locationPatterns[i];
                futures.add(executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DefaultResourceScanner resourceScanner = new DefaultResourceScanner(loader);
                            resourceScanner.setExecutorService(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
                            Collections2.addAll(result, resourceScanner.scan(string));
                            resourceScanner.getExecutorService().shutdownNow();
                        }
                        catch (IOException e) {
                            throw new NestedIOException(e);
                        }
                    }
                }));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    Exceptions.uncheckAndThrow(e);
                }
            }
            executorService.shutdownNow();
            return new SimpleResourceSet(result.toArray(new Resource[result.size()]));
        }
        return Resources.scan(locationPatterns[0]);
    }

    public static ResourceSet scan(Resource rootDirResource, String subPattern) throws NestedIOException {
        Args.notNull(rootDirResource, "rootDirResource");
        Args.notEmpty(subPattern, "subPattern");
        try {
            return new SimpleResourceSet(scanner.scan(rootDirResource, subPattern));
        }
        catch (IOException e) {
            throw Exceptions.wrap(e);
        }
    }

    public static String extractRootDirPath(String locationPattern) {
        return scanner.extractRootDirPath(locationPattern);
    }

    protected Resources() {
    }
}

