/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import leap.lang.Args;
import leap.lang.path.Paths;
import leap.lang.resource.AbstractResource;
import leap.lang.resource.FileResource;

class SimpleFileResource
extends AbstractResource
implements FileResource {
    private final File file;
    private final String path;
    private final String path1;
    private final String classpath;

    public SimpleFileResource(File file) {
        this(file, null);
    }

    public SimpleFileResource(File file, String classpath) {
        Args.notNull(file, "file");
        this.file = file;
        this.path = Paths.normalize(file.getPath());
        this.path1 = file.isDirectory() ? this.path + "/" : this.path;
        this.classpath = classpath;
    }

    public SimpleFileResource(String path) {
        this(path, null);
    }

    public SimpleFileResource(String path, String classpath) {
        Args.notNull(path, "path");
        this.file = new File(path);
        this.path = Paths.normalize(path);
        this.path1 = this.file.isDirectory() ? path + "/" : path;
        this.classpath = classpath;
    }

    public final String getPath() {
        return this.path;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isReadable() {
        return this.file.canRead() && !this.file.isDirectory();
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public URL getURL() throws IOException {
        return this.file.toURI().toURL();
    }

    @Override
    public URI getURI() throws IOException {
        return this.file.toURI();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public long contentLength() throws IOException {
        return this.file.length();
    }

    @Override
    public SimpleFileResource createRelative(String relativePath) {
        String pathToUse = Paths.normalize(Paths.applyRelative(this.path1, relativePath));
        return new SimpleFileResource(pathToUse, relativePath);
    }

    @Override
    public String getFilename() {
        return this.file.getName();
    }

    @Override
    public String getClasspath() {
        return this.classpath;
    }

    @Override
    public String getDescription() {
        return "file [" + this.file.getAbsolutePath() + "]";
    }

    @Override
    public boolean isWritable() {
        return this.file.canWrite() && !this.file.isDirectory();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.file);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof SimpleFileResource && this.path.equals(((SimpleFileResource)obj).path);
    }

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public String toString() {
        if (null != this.classpath && this.classpath.length() > 0) {
            return "classpath:" + this.classpath;
        }
        return this.getDescription();
    }
}

