/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import leap.lang.Args;
import leap.lang.Arrays2;
import leap.lang.Classes;
import leap.lang.Strings;
import leap.lang.asm.ClassReader;
import leap.lang.collection.ArrayIterable;
import leap.lang.exception.NestedClassNotFoundException;
import leap.lang.exception.NestedIOException;
import leap.lang.io.IO;
import leap.lang.resource.Resource;
import leap.lang.resource.ResourceSet;
import leap.lang.resource.Resources;

public class SimpleResourceSet
extends ArrayIterable<Resource>
implements ResourceSet {
    protected Set<Class<?>> classes;

    public SimpleResourceSet(Resource[] values) {
        super(values);
    }

    @Override
    public Resource[] toResourceArray() {
        return (Resource[])this.values;
    }

    @Override
    public Resource getClasspathResource(String name) {
        Args.notEmpty(name, "name");
        for (Resource r : (Resource[])this.values) {
            if (!Strings.equals(r.getClasspath(), name)) continue;
            return r;
        }
        return null;
    }

    @Override
    public Resource[] search(Predicate<Resource> predicate) {
        return Arrays2.filter(this.values, predicate).toArray(new Resource[0]);
    }

    @Override
    public Resource[] searchUrls(String ... locationPatterns) {
        Args.notNull(locationPatterns, "location patterns");
        LinkedHashSet<Resource> resources = new LinkedHashSet<Resource>();
        for (String locationPattern : locationPatterns) {
            try {
                for (int i = 0; i < ((Resource[])this.values).length; ++i) {
                    Resource resource = ((Resource[])this.values)[i];
                    if (!Resources.matcher.match(locationPattern, resource.getURL().toExternalForm())) continue;
                    resources.add(resource);
                }
            }
            catch (IOException e) {
                throw new NestedIOException(e);
            }
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    @Override
    public Resource[] searchClasspaths(String ... classpathPatterns) {
        Args.notNull(classpathPatterns, "classpath patterns");
        LinkedHashSet<Resource> resources = new LinkedHashSet<Resource>();
        for (String classpathPattern : classpathPatterns) {
            if (classpathPattern.startsWith("/")) {
                classpathPattern = classpathPattern.substring(1);
            }
            for (int i = 0; i < ((Resource[])this.values).length; ++i) {
                Resource resource = ((Resource[])this.values)[i];
                if (null == resource.getClasspath() || !Resources.matcher.match(classpathPattern, resource.getClasspath())) continue;
                resources.add(resource);
            }
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    @Override
    public Class<?>[] searchClasses() {
        this.loadAllClasses();
        return this.classes.toArray(new Class[this.classes.size()]);
    }

    @Override
    public Class<?>[] searchClasses(String basePackage) {
        Args.notEmpty(basePackage, "base package");
        this.loadAllClasses();
        String basePackageEndsWithDot = null;
        if (basePackage.endsWith(".")) {
            basePackageEndsWithDot = basePackage;
            basePackage = basePackage.substring(0, basePackage.length() - 1);
        } else {
            basePackageEndsWithDot = basePackage + ".";
        }
        LinkedHashSet classes = new LinkedHashSet(16);
        for (Class<?> clazz : this.classes) {
            String packageName = Classes.getPackageName(clazz);
            if (!packageName.equals(basePackage) && !packageName.startsWith(basePackageEndsWithDot)) continue;
            classes.add(clazz);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    @Override
    public Class<?>[] searchClasses(String basePackage, Predicate<Class<?>> predicate) {
        Args.notEmpty(basePackage, "base package");
        Args.notNull(predicate);
        this.loadAllClasses();
        String basePackageEndsWithDot = null;
        if (basePackage.endsWith(".")) {
            basePackageEndsWithDot = basePackage;
            basePackage = basePackage.substring(0, basePackage.length() - 1);
        } else {
            basePackageEndsWithDot = basePackage + ".";
        }
        LinkedHashSet classes = new LinkedHashSet(16);
        for (Class<?> clazz : this.classes) {
            String packageName = Classes.getPackageName(clazz);
            if (!packageName.equals(basePackage) && !packageName.startsWith(basePackageEndsWithDot) || !predicate.test(clazz)) continue;
            classes.add(clazz);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    @Override
    public Class<?>[] searchClasses(Predicate<Class<?>> predicate) {
        Args.notNull(predicate);
        this.loadAllClasses();
        LinkedHashSet classes = new LinkedHashSet(16);
        for (Class<?> clazz : this.classes) {
            if (!predicate.test(clazz)) continue;
            classes.add(clazz);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    @Override
    public void process(Consumer<Resource> action) {
        Args.notNull(action);
        for (Resource r : (Resource[])this.values) {
            action.accept(r);
        }
    }

    @Override
    public void processClasses(Consumer<Class<?>> action) {
        Args.notNull(action);
        this.loadAllClasses();
        for (Class<?> clazz : this.classes) {
            action.accept(clazz);
        }
    }

    protected void loadAllClasses() {
        if (null == this.classes) {
            this.classes = new LinkedHashSet();
            for (int i = 0; i < ((Resource[])this.values).length; ++i) {
                Resource resource = ((Resource[])this.values)[i];
                if (null == resource.getClasspath() || !Strings.endsWith(resource.getFilename(), ".class")) continue;
                InputStream is = null;
                try {
                    is = resource.getInputStream();
                    ClassReader classReader = new ClassReader(is);
                    String internalClassName = classReader.getClassName();
                    String className = internalClassName.replace('/', '.');
                    this.classes.add(Class.forName(className, false, Classes.getClassLoader()));
                    continue;
                }
                catch (IOException e) {
                    throw new NestedIOException("Error loading .class file " + resource.getDescription() + "' : " + e.getMessage(), e);
                }
                catch (ClassNotFoundException e) {
                    throw new NestedClassNotFoundException(e.getMessage(), e);
                }
                finally {
                    IO.close(is);
                }
            }
        }
    }
}

