/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import leap.lang.Args;
import leap.lang.Exceptions;
import leap.lang.net.NET;
import leap.lang.net.Urls;
import leap.lang.path.Paths;
import leap.lang.resource.AbstractFileResolvingResource;
import leap.lang.resource.Resource;

public class UrlResource
extends AbstractFileResolvingResource {
    private final URL url;
    private final URL cleanedUrl;
    private final URI uri;
    private final String classpath;
    private String classpathPrefix;

    public UrlResource(URL url) {
        this(url, null);
    }

    public UrlResource(URL url, String classpathPrefix) {
        Args.notNull(url, "url");
        this.url = url;
        this.cleanedUrl = this.getCleanedUrl(this.url, url.toString());
        this.uri = null;
        this.classpathPrefix = classpathPrefix;
        this.classpath = this.determinateClasspath();
    }

    public UrlResource(URI uri) throws MalformedURLException {
        Args.notNull(uri, "uri");
        this.url = uri.toURL();
        this.cleanedUrl = this.getCleanedUrl(this.url, uri.toString());
        this.uri = uri;
        this.classpath = this.determinateClasspath();
    }

    public UrlResource(String path) throws MalformedURLException {
        Args.notNull(path, "path");
        this.url = new URL(path);
        this.cleanedUrl = this.getCleanedUrl(this.url, path);
        this.uri = null;
        this.classpath = this.determinateClasspath();
    }

    private String determinateClasspath() {
        String urlString;
        int separatorIndex;
        if (Urls.isJarUrl(this.url)) {
            String urlString2 = this.url.toString();
            int separatorIndex2 = urlString2.lastIndexOf("!/");
            if (separatorIndex2 != -1) {
                return urlString2.substring(separatorIndex2 + 2);
            }
        } else if (null != this.classpathPrefix && Urls.isFileUrl(this.url) && (separatorIndex = (urlString = this.url.toString()).indexOf(this.classpathPrefix)) != -1) {
            return urlString.substring(separatorIndex);
        }
        return null;
    }

    private URL getCleanedUrl(URL originalUrl, String originalPath) {
        try {
            return new URL(Paths.normalize(originalPath));
        }
        catch (MalformedURLException ex) {
            return originalUrl;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        URLConnection con = this.url.openConnection();
        NET.useCachesIfNecessary(con);
        try {
            return con.getInputStream();
        }
        catch (IOException ex) {
            if (con instanceof HttpURLConnection) {
                ((HttpURLConnection)con).disconnect();
            }
            throw ex;
        }
    }

    @Override
    public URL getURL() throws IOException {
        return this.url;
    }

    @Override
    public URI getURI() throws IOException {
        if (this.uri != null) {
            return this.uri;
        }
        return super.getURI();
    }

    @Override
    public File getFile() {
        if (this.uri != null) {
            try {
                return super.getFile(this.uri);
            }
            catch (IOException e) {
                throw Exceptions.wrap(e);
            }
        }
        return super.getFile();
    }

    @Override
    public Resource createRelative(String relativePath) throws MalformedURLException {
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return new UrlResource(new URL(this.url, relativePath), this.classpathPrefix);
    }

    @Override
    public String getFilename() {
        return new File(this.url.getFile()).getName();
    }

    @Override
    public String getClasspath() {
        return this.classpath;
    }

    @Override
    public String getDescription() {
        return "URL [" + this.url + "]";
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof UrlResource && this.cleanedUrl.equals(((UrlResource)obj).cleanedUrl);
    }

    @Override
    public int hashCode() {
        return this.cleanedUrl.hashCode();
    }
}

