/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.security;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import leap.lang.Randoms;
import leap.lang.codec.Base64;

public class AES {
    public static final String ALGORITHM = "AES";
    public static final int DEFAULT_SIZE = 256;
    private static final KeyGenerator g;

    public static SecretKey generateKey() {
        return g.generateKey();
    }

    public static String encodeSecretKey(SecretKey key) {
        return Base64.encode(key.getEncoded());
    }

    public static SecretKey decodeSecretKey(String encoded) {
        return new SecretKeySpec(Base64.decodeToBytes(encoded), ALGORITHM);
    }

    protected AES() {
    }

    static {
        try {
            g = KeyGenerator.getInstance(ALGORITHM);
            g.init(256, new SecureRandom(Randoms.nextString(20).getBytes()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

