/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.serialize;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import leap.lang.Assert;
import leap.lang.serialize.JsonSerializer;
import leap.lang.serialize.Serialize;
import leap.lang.serialize.Serializer;

public class Serializes {
    public static final String JSON = "json";
    private static final Map<String, Serializer> serializers = new ConcurrentHashMap<String, Serializer>();

    public static void register(String name, Serializer serializer) {
        serializers.put(name, serializer);
    }

    public static Serializer getSerializer(String name) {
        return serializers.get(name);
    }

    public static Serializer ensureGetSerializer(String name) {
        Serializer serializer = serializers.get(name);
        Assert.notNull(serializer, "serializer '" + name + "' not registered");
        return serializer;
    }

    public static Serializer getSerializer(Serialize annotation) {
        if (null == annotation) {
            return null;
        }
        return Serializes.ensureGetSerializer(annotation.value());
    }

    protected Serializes() {
    }

    static {
        Serializes.register(JSON, new JsonSerializer());
    }
}

