/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import leap.lang.Args;
import leap.lang.Locales;
import leap.lang.Strings;
import leap.lang.http.MimeTypes;
import leap.lang.servlet.ServletResource;
import leap.lang.servlet.SimpleServletResource;

public class Servlets {
    public static final String INCLUDE_REQUEST_URI_ATTRIBUTE = "javax.servlet.include.request_uri";
    public static final String INCLUDE_CONTEXT_PATH_ATTRIBUTE = "javax.servlet.include.context_path";
    public static final String INCLUDE_SERVLET_PATH_ATTRIBUTE = "javax.servlet.include.servlet_path";
    public static final String INCLUDE_PATH_INFO_ATTRIBUTE = "javax.servlet.include.path_info";
    public static final String INCLUDE_QUERY_STRING_ATTRIBUTE = "javax.servlet.include.query_string";
    public static final String FORWARD_REQUEST_URI_ATTRIBUTE = "javax.servlet.forward.request_uri";
    public static final String FORWARD_CONTEXT_PATH_ATTRIBUTE = "javax.servlet.forward.context_path";
    public static final String FORWARD_SERVLET_PATH_ATTRIBUTE = "javax.servlet.forward.servlet_path";
    public static final String FORWARD_PATH_INFO_ATTRIBUTE = "javax.servlet.forward.path_info";
    public static final String FORWARD_QUERY_STRING_ATTRIBUTE = "javax.servlet.forward.query_string";
    public static final String ERROR_STATUS_CODE_ATTRIBUTE = "javax.servlet.error.status_code";
    public static final String ERROR_EXCEPTION_TYPE_ATTRIBUTE = "javax.servlet.error.exception_type";
    public static final String ERROR_MESSAGE_ATTRIBUTE = "javax.servlet.error.message";
    public static final String ERROR_EXCEPTION_ATTRIBUTE = "javax.servlet.error.exception";
    public static final String ERROR_REQUEST_URI_ATTRIBUTE = "javax.servlet.error.request_uri";
    public static final String ERROR_SERVLET_NAME_ATTRIBUTE = "javax.servlet.error.servlet_name";
    public static final String TEMP_DIR_CONTEXT_ATTRIBUTE = "javax.servlet.context.tempdir";

    public static ServletResource getResource(ServletContext sc, String path) {
        return new SimpleServletResource(sc, path);
    }

    public static ServletResource getResource(ServletContext sc, String path, Locale locale) {
        String[] paths;
        for (String p : paths = Locales.getLocaleFilePaths(locale, path)) {
            try {
                if (null == sc.getResource(p)) continue;
                return new SimpleServletResource(sc, p);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Map<String, String> getInitParamsMap(FilterConfig config) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Enumeration names = config.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = config.getInitParameter(name);
            map.put(name, value);
        }
        return map;
    }

    public static Map<String, String> getInitParamsMap(ServletConfig config) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Enumeration names = config.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = config.getInitParameter(name);
            map.put(name, value);
        }
        return map;
    }

    public static Map<String, String> getInitParamsMap(ServletContext sc) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Enumeration names = sc.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = sc.getInitParameter(name);
            map.put(name, value);
        }
        return map;
    }

    public static String getRealPath(ServletContext servletContext, String path) throws FileNotFoundException {
        String realPath;
        Args.notNull(servletContext, "servletContext");
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((realPath = servletContext.getRealPath(path)) == null) {
            throw new FileNotFoundException("ServletContext resource [" + path + "] cannot be resolved to absolute file path - web application archive not expanded?");
        }
        return realPath;
    }

    public static String getRequestUriWithQueryString(HttpServletRequest request) {
        StringBuilder uri = new StringBuilder(request.getRequestURI());
        if (!Strings.isEmpty(request.getQueryString())) {
            uri.append('?').append(request.getQueryString());
        }
        return uri.toString();
    }

    public static String getRequestPathFromUri(String url) {
        return Servlets.getRequestPathFromUri(url, "");
    }

    public static String getRequestPathFromUri(String url, String contextPath) {
        if (null == url) {
            return null;
        }
        try {
            URI uri = new URI(url);
            String path = uri.getPath();
            if (!Strings.isEmpty(contextPath)) {
                return path.substring(contextPath.length());
            }
            return path;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid url '" + url + ", " + e.getMessage(), e);
        }
    }

    public static boolean isIncludeRequest(ServletRequest request) {
        return request.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE) != null;
    }

    public static File getTempDir(ServletContext servletContext) {
        Args.notNull(servletContext, "ServletContext");
        return (File)servletContext.getAttribute(TEMP_DIR_CONTEXT_ATTRIBUTE);
    }

    public static String getMimeType(ServletContext sc, String filename) {
        String mimeType = sc.getMimeType(filename);
        if (Strings.isEmpty(mimeType)) {
            mimeType = MimeTypes.getMimeType(filename);
        }
        return mimeType;
    }

    protected Servlets() {
    }
}

