/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.ServletContext;
import leap.lang.Args;
import leap.lang.Exceptions;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.lang.net.Urls;
import leap.lang.path.PathMatcher;
import leap.lang.path.Paths;
import leap.lang.resource.AbstractFileResolvingResource;
import leap.lang.resource.ContextResource;
import leap.lang.resource.Resources;
import leap.lang.servlet.ServletResource;
import leap.lang.servlet.Servlets;

public class SimpleServletResource
extends AbstractFileResolvingResource
implements ContextResource,
ServletResource {
    private static final Log log = LogFactory.get(SimpleServletResource.class);
    private final ServletContext servletContext;
    private final String path;

    public SimpleServletResource(ServletContext servletContext, String path) {
        Args.notNull(servletContext, "servletContext");
        this.servletContext = servletContext;
        Args.notNull(path, "path");
        String pathToUse = Paths.normalize(path);
        if (!pathToUse.startsWith("/")) {
            pathToUse = "/" + pathToUse;
        }
        this.path = pathToUse;
    }

    @Override
    public final ServletContext getServletContext() {
        return this.servletContext;
    }

    public final String getPath() {
        return this.path;
    }

    @Override
    public boolean exists() {
        try {
            URL url = this.servletContext.getResource(this.path);
            return url != null;
        }
        catch (Exception ex) {
            log.info("Error calling ServletContext.getResource on path : " + this.path, ex);
            return false;
        }
    }

    @Override
    public boolean isReadable() {
        InputStream is = this.servletContext.getResourceAsStream(this.path);
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is = this.servletContext.getResourceAsStream(this.path);
        if (is == null) {
            throw new FileNotFoundException("Could not open " + this.getDescription());
        }
        return is;
    }

    @Override
    public URL getURL() throws IOException {
        URL url = this.servletContext.getResource(this.path);
        if (url == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL because it does not exist");
        }
        return url;
    }

    @Override
    public File getFile() {
        try {
            URL url = this.servletContext.getResource(this.path);
            if (url != null && Urls.isFileUrl(url)) {
                return super.getFile();
            }
            if (url != null && Urls.isJarUrl(url)) {
                return new File(url.getFile());
            }
            String realPath = Servlets.getRealPath(this.servletContext, this.path);
            return new File(realPath);
        }
        catch (IOException e) {
            throw Exceptions.wrap(e);
        }
    }

    @Override
    public SimpleServletResource createRelative(String relativePath) {
        String pathToUse = Paths.applyRelative(this.path, relativePath);
        return new SimpleServletResource(this.servletContext, pathToUse);
    }

    @Override
    public ServletResource[] scan(String subPattern) {
        Args.notEmpty(subPattern, "subPattern");
        Set subPaths = this.servletContext.getResourcePaths(this.path);
        ArrayList<SimpleServletResource> resources = new ArrayList<SimpleServletResource>();
        PathMatcher matcher = Resources.getPathMatcher();
        for (String subPath : subPaths) {
            if (!matcher.match(subPattern, subPath)) continue;
            resources.add(new SimpleServletResource(this.servletContext, subPath));
        }
        return resources.toArray(new SimpleServletResource[resources.size()]);
    }

    @Override
    public String getFilename() {
        return Paths.getFileName(this.path);
    }

    @Override
    public String getDescription() {
        return "ServletContext resource [" + this.path + "]";
    }

    @Override
    public String getPathWithinContext() {
        return this.path;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SimpleServletResource) {
            SimpleServletResource otherRes = (SimpleServletResource)obj;
            return this.servletContext.equals(otherRes.servletContext) && this.path.equals(otherRes.path);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }
}

