/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.st.stpl;

import leap.lang.Objects2;
import leap.lang.Strings;
import leap.lang.convert.Converts;
import leap.lang.params.Params;
import leap.lang.st.stpl.StplParser;
import leap.lang.st.stpl.StplTemplate;

abstract class StplNode {
    StplNode() {
    }

    abstract boolean render(StringBuilder var1, Params var2);

    static class ClauseNode
    extends StplNode {
        private StplTemplate tpl;

        ClauseNode(String text) {
            this.tpl = StplParser.parse(text);
        }

        @Override
        public boolean render(StringBuilder out, Params params) {
            for (StplNode expr : this.tpl.getNodes()) {
                String name;
                Object value;
                if (!(expr instanceof ReplaceNode) || !Objects2.isEmpty(value = params.get(name = ((ReplaceNode)expr).param))) continue;
                return false;
            }
            this.tpl.render(out, params);
            return true;
        }

        public String toString() {
            return "{?" + this.tpl.getText() + "}";
        }
    }

    static class ReplaceNode
    extends StplNode {
        private String param;

        ReplaceNode(String param) {
            this.param = param;
        }

        @Override
        public boolean render(StringBuilder out, Params params) {
            String string;
            Object value = params.get(this.param);
            if (null != value && null != (string = Strings.trimToNull(Converts.toString(value)))) {
                out.append(string);
                return true;
            }
            return false;
        }

        public String toString() {
            return "$" + this.param + "$";
        }
    }

    static class TextNode
    extends StplNode {
        private String text;

        TextNode(String text) {
            this.text = text;
        }

        @Override
        public boolean render(StringBuilder out, Params params) {
            out.append(this.text);
            return true;
        }

        public String toString() {
            return this.text;
        }
    }
}

