/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.st.stpl;

import java.util.ArrayList;
import leap.lang.st.stpl.StplNode;
import leap.lang.st.stpl.StplTemplate;

class StplParser {
    private static final int TOKEN_REPLACE_START = 1;
    private static final int TOKEN_DYNAMIC_START = 2;

    StplParser() {
    }

    public static StplTemplate parse(String text) {
        char[] chars = text.toCharArray();
        int len = chars.length;
        int token = -1;
        int cursor = 0;
        int start0 = 0;
        int start1 = 0;
        ArrayList<StplNode> nodes = new ArrayList<StplNode>();
        block4: for (int pos = 0; pos < len; ++pos) {
            char ch = chars[pos];
            if (Character.isWhitespace(ch)) {
                if (token != 1) continue;
                token = -1;
                continue;
            }
            switch (ch) {
                case '$': {
                    if (token == -1) {
                        token = 1;
                        start0 = pos;
                        continue block4;
                    }
                    if (token != 1) continue block4;
                    if (start0 == pos - 1) {
                        token = 1;
                        start0 = pos;
                        continue block4;
                    }
                    if (cursor < start0) {
                        nodes.add(new StplNode.TextNode(text.substring(cursor, start0)));
                    }
                    nodes.add(new StplNode.ReplaceNode(text.substring(start0 + 1, pos)));
                    token = -1;
                    cursor = pos + 1;
                    continue block4;
                }
                case '{': {
                    start0 = pos;
                    if (pos >= len - 1 || chars[pos + 1] != '?') continue block4;
                    start1 = ++pos;
                    token = 2;
                    while (pos < len) {
                        ch = chars[pos];
                        if (ch == '}') {
                            if (cursor < start0) {
                                nodes.add(new StplNode.TextNode(text.substring(cursor, start0)));
                            }
                            nodes.add(new StplNode.ClauseNode(text.substring(start1 + 1, pos)));
                            token = -1;
                            cursor = pos + 1;
                            continue block4;
                        }
                        if (token == -1) continue block4;
                        ++pos;
                    }
                    continue block4;
                }
            }
        }
        if (cursor < len) {
            nodes.add(new StplNode.TextNode(text.substring(cursor, len)));
        }
        return new StplTemplate(text, nodes.toArray(new StplNode[nodes.size()]));
    }
}

