/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.st.stpl;

import java.util.Map;
import leap.lang.params.MapParams;
import leap.lang.params.Params;
import leap.lang.st.stpl.StplNode;
import leap.lang.st.stpl.StplParser;

public class StplTemplate {
    private final String text;
    private final StplNode[] nodes;

    public static StplTemplate parse(String text) {
        return StplParser.parse(text);
    }

    public static String render(String template, Map<String, Object> params) {
        return StplTemplate.parse(template).render(params);
    }

    public static String render(String template, Params params) {
        return StplTemplate.parse(template).render(params);
    }

    StplTemplate(String text, StplNode[] nodes) {
        this.text = text;
        this.nodes = nodes;
    }

    public String getText() {
        return this.text;
    }

    protected StplNode[] getNodes() {
        return this.nodes;
    }

    public String render(Params params) {
        StringBuilder out = new StringBuilder(this.text.length());
        this.render(out, params);
        return out.toString();
    }

    public String render(Map<String, Object> params) {
        return this.render(new MapParams(params));
    }

    public void render(StringBuilder out, Params params) {
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].render(out, params);
        }
    }

    public void render(StringBuilder out, Map<String, Object> params) {
        this.render(out, new MapParams(params));
    }
}

