/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.text;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import leap.lang.Strings;
import leap.lang.accessor.MapPropertyAccessor;
import leap.lang.accessor.PropertyGetter;
import leap.lang.text.PlaceholderResolver;

public class DefaultPlaceholderResolver
implements PlaceholderResolver {
    protected String placeholderPrefix = "${";
    protected String placeholderSuffix = "}";
    protected String valueSeparator = ":";
    protected boolean ignoreUnresolvablePlaceholders = false;
    protected boolean emptyUnresolvablePlaceholders = true;
    protected PropertyGetter properties;

    public DefaultPlaceholderResolver(PropertyGetter properties) {
        this.properties = properties;
    }

    public DefaultPlaceholderResolver(Map<String, String> properties) {
        this(new MapPropertyAccessor(properties));
    }

    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    public String getValueSeparator() {
        return this.valueSeparator;
    }

    public void setValueSeparator(String valueSeparator) {
        this.valueSeparator = valueSeparator;
    }

    public boolean isIgnoreUnresolvablePlaceholders() {
        return this.ignoreUnresolvablePlaceholders;
    }

    public void setIgnoreUnresolvablePlaceholders(boolean ignoreUnresolvablePlaceholders) {
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    public boolean isEmptyUnresolvablePlaceholders() {
        return this.emptyUnresolvablePlaceholders;
    }

    public void setEmptyUnresolvablePlaceholders(boolean emptyUnresolvablePlaceholders) {
        this.emptyUnresolvablePlaceholders = emptyUnresolvablePlaceholders;
    }

    @Override
    public boolean hasPlaceholder(String value) {
        if (null == value) {
            return false;
        }
        int prefix = value.indexOf(this.placeholderPrefix);
        if (prefix < 0) {
            return false;
        }
        int suffix = value.indexOf(this.placeholderSuffix, prefix + this.placeholderPrefix.length());
        return suffix >= 0;
    }

    @Override
    public String resolveString(String value) {
        if (Strings.isEmpty(value)) {
            return value;
        }
        int startIndex = value.indexOf(this.placeholderPrefix);
        if (startIndex < 0) {
            return value;
        }
        return this.parseStringValue(value, new HashSet<String>(), startIndex);
    }

    @Override
    public String resolveString(String value, String defaultValue) {
        String resolved = this.resolveString(value);
        if (Strings.equals(resolved, value)) {
            return this.resolveString(defaultValue);
        }
        if (value.length() > 0 && this.emptyUnresolvablePlaceholders && resolved.isEmpty()) {
            return this.resolveString(defaultValue);
        }
        return resolved;
    }

    protected String parseStringValue(String strVal, Set<String> visitedPlaceholders) {
        int startIndex = strVal.indexOf(this.placeholderPrefix);
        if (startIndex < 0) {
            return strVal;
        }
        return this.parseStringValue(strVal, visitedPlaceholders, startIndex);
    }

    protected String parseStringValue(String strVal, Set<String> visitedPlaceholders, int startIndex) {
        StringBuilder buf = new StringBuilder(strVal);
        while (startIndex != -1) {
            int endIndex = this.findPlaceholderEndIndex(buf, startIndex);
            if (endIndex != -1) {
                int separatorIndex;
                String placeholder = buf.substring(startIndex + this.placeholderPrefix.length(), endIndex);
                String originalPlaceholder = placeholder;
                if (!visitedPlaceholders.add(originalPlaceholder)) {
                    throw new IllegalArgumentException("Circular placeholder reference '" + originalPlaceholder + "' in property definitions");
                }
                String propVal = this.properties.getProperty(placeholder = this.parseStringValue(placeholder, visitedPlaceholders));
                if (propVal == null && this.valueSeparator != null && (separatorIndex = placeholder.indexOf(this.valueSeparator)) != -1) {
                    String actualPlaceholder = placeholder.substring(0, separatorIndex);
                    String defaultValue = placeholder.substring(separatorIndex + this.valueSeparator.length());
                    propVal = this.properties.getProperty(actualPlaceholder);
                    if (propVal == null) {
                        propVal = defaultValue;
                    }
                }
                if (null == propVal && this.emptyUnresolvablePlaceholders) {
                    propVal = "";
                }
                if (propVal != null) {
                    if (!Strings.isEmpty(propVal)) {
                        propVal = this.parseStringValue(propVal, visitedPlaceholders);
                    }
                    buf.replace(startIndex, endIndex + this.placeholderSuffix.length(), propVal);
                    startIndex = buf.indexOf(this.placeholderPrefix, startIndex + propVal.length());
                } else if (this.ignoreUnresolvablePlaceholders) {
                    startIndex = buf.indexOf(this.placeholderPrefix, endIndex + this.placeholderSuffix.length());
                } else {
                    throw new IllegalArgumentException("Could not resolve placeholder '" + placeholder + "' in string value \"" + strVal + "\"");
                }
                visitedPlaceholders.remove(originalPlaceholder);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }

    private int findPlaceholderEndIndex(CharSequence buf, int startIndex) {
        int index = startIndex + this.placeholderPrefix.length();
        int withinNestedPlaceholder = 0;
        while (index < buf.length()) {
            if (DefaultPlaceholderResolver.substringMatch(buf, index, this.placeholderSuffix)) {
                if (withinNestedPlaceholder > 0) {
                    --withinNestedPlaceholder;
                    index += this.placeholderSuffix.length();
                    continue;
                }
                return index;
            }
            ++index;
        }
        return -1;
    }

    private static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        for (int j = 0; j < substring.length(); ++j) {
            int i = index + j;
            if (i < str.length() && str.charAt(i) == substring.charAt(j)) continue;
            return false;
        }
        return true;
    }
}

