/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.text;

import java.util.Map;

public class KeyValueParser {
    public static void parseKeyValuePairs(Map<String, String> pairs, String string) {
        KeyValueParser.parseKeyValuePairs(pairs, string, ':');
    }

    public static void parseKeyValuePairs(Map<String, String> pairs, String string, char seperator) {
        string = string.trim();
        for (int i = 0; i < string.length(); ++i) {
            char ch;
            while (i < string.length() && Character.isWhitespace(ch = string.charAt(i))) {
                ++i;
            }
            int mark = i;
            String key = null;
            String value = null;
            while (i < string.length()) {
                ch = string.charAt(i);
                if (ch == seperator) {
                    key = string.substring(mark, i).trim();
                    ++i;
                    break;
                }
                ++i;
            }
            while (i < string.length() && Character.isWhitespace(ch = string.charAt(i))) {
                ++i;
            }
            mark = i;
            ch = string.charAt(i);
            while (i < string.length()) {
                ch = string.charAt(i);
                if (ch == ',') {
                    value = string.substring(mark, i).trim();
                    break;
                }
                ++i;
            }
            if (null == value && mark < i) {
                value = string.substring(mark, i).trim();
            }
            if (null == key || null == value) {
                throw new InvalidKeyValueStringException("Invalid key-value string '" + string + "', must be 'key" + seperator + "value' format");
            }
            pairs.put(key, value);
        }
    }

    public static final class InvalidKeyValueStringException
    extends RuntimeException {
        private static final long serialVersionUID = -734586009003744561L;

        public InvalidKeyValueStringException() {
        }

        public InvalidKeyValueStringException(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidKeyValueStringException(String message) {
            super(message);
        }

        public InvalidKeyValueStringException(Throwable cause) {
            super(cause);
        }
    }
}

