/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.text;

public final class PrintFormat {
    public static final int JUST_LEFT = 108;
    public static final int JUST_CENTER = 99;
    public static final int JUST_RIGHT = 114;
    private int just;
    private int maxChars;

    public PrintFormat(int maxChars) {
        this(maxChars, 108);
    }

    public PrintFormat(int maxChars, int justn) {
        switch (justn) {
            case 99: 
            case 108: 
            case 114: {
                this.just = justn;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid justification arg.");
            }
        }
        if (maxChars < 1) {
            throw new IllegalArgumentException("maxChars must be positive.");
        }
        this.maxChars = maxChars;
    }

    public int maxChars() {
        return this.maxChars;
    }

    public StringBuffer format(String s, StringBuffer where) {
        String wanted;
        if (null == s) {
            s = "";
        }
        if ((wanted = s.substring(0, Math.min(s.length(), this.maxChars))).length() > this.maxChars) {
            where.append(wanted);
        } else {
            switch (this.just) {
                case 114: {
                    this.pad(where, this.maxChars - wanted.length());
                    where.append(wanted);
                    break;
                }
                case 99: {
                    int startPos = where.length();
                    this.pad(where, (this.maxChars - wanted.length()) / 2);
                    where.append(wanted);
                    this.pad(where, (this.maxChars - wanted.length()) / 2);
                    this.pad(where, this.maxChars - (where.length() - startPos));
                    break;
                }
                case 108: {
                    where.append(wanted);
                    this.pad(where, this.maxChars - wanted.length());
                }
            }
        }
        return where;
    }

    public String format(String s) {
        return this.format(s, new StringBuffer()).toString();
    }

    protected final void pad(StringBuffer to, int howMany) {
        for (int i = 0; i < howMany; ++i) {
            to.append(' ');
        }
    }
}

