/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.text;

public final class StringCharacterIterator {
    private String s;
    private int pos;
    private char curr;
    private int upperBound;

    public StringCharacterIterator(String s) {
        this.s = s;
        this.pos = -1;
        this.upperBound = s.length() - 1;
    }

    public String getInput() {
        return this.s;
    }

    public boolean isEnd() {
        return this.pos == this.upperBound;
    }

    public boolean hasNext() {
        return this.pos < this.upperBound;
    }

    public boolean next() {
        if (!this.hasNext()) {
            return false;
        }
        this.curr = this.s.charAt(++this.pos);
        return true;
    }

    public char nextChar() {
        if (!this.hasNext()) {
            throw new IllegalStateException("No next char");
        }
        this.curr = this.s.charAt(++this.pos);
        return this.curr;
    }

    public char charAt(int index) throws IndexOutOfBoundsException {
        return this.s.charAt(index);
    }

    public char peek() throws IllegalStateException {
        if (this.pos == this.upperBound) {
            throw new IllegalStateException("cannot peek next character,current position is at the end of input string");
        }
        return this.s.charAt(this.pos + 1);
    }

    public int pos() {
        return this.pos;
    }

    public int upperBound() {
        return this.upperBound;
    }

    public String substring(int indexFrom, int indexTo, boolean trim) throws IndexOutOfBoundsException {
        return trim ? this.s.substring(indexFrom, indexTo).trim() : this.s.substring(indexFrom, indexTo);
    }

    public char nextNonWhitespaceChar() throws IllegalStateException {
        do {
            if (this.next()) continue;
            throw new IllegalStateException("cannot next to non white space character, position is end");
        } while (Character.isWhitespace(this.curr));
        return this.curr;
    }

    public void move(int newPosition) throws IndexOutOfBoundsException {
        if (newPosition > this.upperBound || newPosition < 0) {
            throw new IndexOutOfBoundsException("The new position " + newPosition + " is out of string's range.");
        }
        this.pos = newPosition;
        this.curr = this.s.charAt(this.pos);
    }

    public char current() throws IllegalStateException {
        if (this.pos == -1) {
            throw new IllegalStateException("no current character, this iterator not used yet");
        }
        return this.curr;
    }
}

