/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.time;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import leap.lang.time.ConcurrentDateFormat;

public class DateFormats {
    private static final Map<String, DateFormat> patternFormats = new ConcurrentHashMap<String, DateFormat>();
    private static final Map<Class<?>, String> defaultPatterns = new ConcurrentHashMap();
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String TIME_PATTERN = "HH:mm:ss";
    public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String ISO8601_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String RFC3339_DATE_PATTERN1 = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String[] DEFAULT_PATTERNS = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ssZ", "HH:mm:ss"};
    public static final ConcurrentDateFormat DATE_FORMAT = new ConcurrentDateFormat("yyyy-MM-dd");
    public static final ConcurrentDateFormat TIME_FORMAT = new ConcurrentDateFormat("HH:mm:ss");
    public static final ConcurrentDateFormat DATETIME_FORMAT = new ConcurrentDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final ConcurrentDateFormat TIMESTAMP_FORMAT = new ConcurrentDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final ConcurrentDateFormat REF_DATE_FORMAT = new ConcurrentDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    protected DateFormats() {
    }

    public static DateFormat getFormat(String pattern) {
        DateFormat format = patternFormats.get(pattern);
        if (null == format) {
            format = new ConcurrentDateFormat(pattern);
            patternFormats.put(pattern, format);
        }
        return format;
    }

    public static DateFormat getFormat(Class<?> type) {
        return DateFormats.getFormat(DateFormats.getPattern(type));
    }

    public static String getPattern(Class<?> type) {
        String pattern = defaultPatterns.get(type);
        return null == pattern ? DATETIME_PATTERN : pattern;
    }

    static {
        patternFormats.put(DATE_PATTERN, DATE_FORMAT);
        patternFormats.put(TIME_PATTERN, TIME_FORMAT);
        patternFormats.put(DATETIME_PATTERN, DATETIME_FORMAT);
        patternFormats.put(TIMESTAMP_PATTERN, TIMESTAMP_FORMAT);
        patternFormats.put(ISO8601_DATE_PATTERN, REF_DATE_FORMAT);
        defaultPatterns.put(Timestamp.class, TIMESTAMP_PATTERN);
        defaultPatterns.put(Time.class, TIME_PATTERN);
        defaultPatterns.put(java.sql.Date.class, DATE_PATTERN);
        defaultPatterns.put(Date.class, DATETIME_PATTERN);
    }
}

